package org.gcube.data.analysis.tabulardata.model.column;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.Integer;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;

public class IdColumn extends Column {
	
	public final static String COLUMN_NAME = "id";
	public final static String COLUMN_LABEL = "id";
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -9100817900638354333L;

	public IdColumn() {
	}

	public ColumnType getColumnType() {
		return ColumnType.ID;
	}

	@Override
	public String getLabel() {
		return COLUMN_LABEL;
	}

	@Override
	public void setLabel(String label) {
		// Do nothing
	}

	@Override
	public boolean hasName() {
		return true;
	}

	@Override
	public String getName() {
		return COLUMN_NAME;
	}

	@Override
	public DataType getDataType() {
		return new Integer();
	}

	@Override
	public boolean hasRelationship() {
		return false;
	}

	@Override
	public ColumnRelationship getRelationship() {
		throw new IllegalStateException("Columns of type " + getColumnType() + " do not support relationships");
	}

	@Override
	public void setName(String name) {
		//Do nothing
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj.getClass()==IdColumn.class) return true;
		return false;
	}
	

}

