package org.gcube.data.analysis.tabulardata.model.table;

import java.util.Collection;
import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.Column;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;

public class GenericTable extends Table{
	
	private List<Column> columns = Lists.newArrayList();

	public GenericTable(long id, String name, Collection<Column> columns) {
		super(id, name);
		this.columns = Lists.newArrayList(columns);
	}

	public GenericTable(String name, Collection<Column> columns) {
		super(name);
		this.columns = Lists.newArrayList(columns);
	}

	@Override
	public TableType getTableType() {
		return TableType.GENERICTABLE;
	}

	@Override
	public List<Column> getColumns() {
		return ImmutableList.copyOf(columns);
	}

}
