package org.gcube.data.analysis.tabulardata.expression.logical;

import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.UnaryExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
@XmlRootElement
public class Not extends UnaryExpression{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1916660370859383155L;


	@SuppressWarnings("unused")
	private Not() {}
	
	public Not(Expression argument) {
		super(argument);
	}


	@Override
	public Operator getOperator() {
		return Operator.NOT;
	}
	
	@Override
	public DataType getReturnedDataType() {		
		return new BooleanType();
	}
}
