/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class BinaryExpression
extends CompositeExpression {
    private static final long serialVersionUID = -1471639807654392162L;
    private Expression leftArgument = null;
    private Expression rightArgument = null;

    protected BinaryExpression() {
    }

    public BinaryExpression(Expression leftArgument, Expression rightArgument) {
        this.leftArgument = leftArgument;
        this.rightArgument = rightArgument;
    }

    public Expression getLeftArgument() {
        return this.leftArgument;
    }

    public void setLeftArgument(Expression leftArgument) {
        this.leftArgument = leftArgument;
    }

    public Expression getRightArgument() {
        return this.rightArgument;
    }

    public void setRightArgument(Expression rightArgument) {
        this.rightArgument = rightArgument;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.leftArgument == null ? 0 : this.leftArgument.hashCode());
        result = 31 * result + (this.rightArgument == null ? 0 : this.rightArgument.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryExpression other = (BinaryExpression)obj;
        if (this.leftArgument == null ? other.leftArgument != null : !this.leftArgument.equals(other.leftArgument)) {
            return false;
        }
        return !(this.rightArgument == null ? other.rightArgument != null : !this.rightArgument.equals(other.rightArgument));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BinaryExpression [");
        builder.append(this.leftArgument + " ");
        builder.append((Object)((Object)this.getOperator()) + " ");
        builder.append(this.rightArgument);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.leftArgument == null) {
            throw new MalformedExpressionException("Left Argument cannot be null, expression : " + this);
        }
        if (this.rightArgument == null) {
            throw new MalformedExpressionException("Right Argument cannot be null, expression : " + this);
        }
        this.leftArgument.validate();
        this.rightArgument.validate();
    }
}

