package org.gcube.data.analysis.tabulardata.model.table;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlSeeAlso;

import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
@XmlSeeAlso({
	CodelistTableType.class,
	DatasetTableType.class,
	DatasetViewTableType.class,
	GenericTableType.class,
	HierarchicalCodelistTableType.class,
	TimeCodelistTableType.class
})
		
public abstract class TableType implements Serializable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 6841440717260930667L;

	public abstract String getCode();
	
	public abstract String getName();
	
	@Override
	public int hashCode(){
		return getCode().hashCode();
	}
	
	@Override
	public boolean equals(Object obj){
		return this.getClass().equals(obj.getClass());
	}
	
	@Override
	public String toString(){
		return getCode();
	}
	
}
