package org.gcube.data.analysis.tabulardata.model.metadata.column;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;

@XmlRootElement(name="DataValidationMetadata")
@XmlAccessorType(XmlAccessType.FIELD)
public class DataValidationMetadata implements ColumnMetadata {

	private static final long serialVersionUID = 5346249544710409540L;

	@XmlElement(type=ImmutableLocalizedText.class)
	private LocalizedText description;
	
	private boolean valid;

	@SuppressWarnings("unused")
	private DataValidationMetadata() {
	}

	public DataValidationMetadata(LocalizedText description, boolean valid) {
		this.description = description;
		this.valid = valid;
	}

	public LocalizedText getDescription() {
		return description;
	}

	public boolean isValid() {
		return valid;
	}


	public boolean isInheritable() {
		return false;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((description == null) ? 0 : description.hashCode());
		result = prime * result + (valid ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DataValidationMetadata other = (DataValidationMetadata) obj;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (valid != other.valid)
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("DataValidationMetadata [description=");
		builder.append(description);
		builder.append(", valid=");
		builder.append(valid);
		builder.append("]");
		return builder.toString();
	}

}
