package org.gcube.data.analysis.tabulardata.model.metadata.column;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;

@XmlRootElement(name="DataValidationMetadata")
@XmlAccessorType(XmlAccessType.FIELD)
public class DataValidationMetadata implements ColumnMetadata {

	private static final long serialVersionUID = 5346249544710409540L;

	@XmlElement(type=ImmutableLocalizedText.class)
	private LocalizedText description;
	
	@XmlElement(type=ImmutableLocalizedText.class)
	private LocalizedText name;
	
	private int invalidRowsCount;
	
	@SuppressWarnings("unused")
	private DataValidationMetadata() {
	}

	public DataValidationMetadata(LocalizedText description,LocalizedText name, int invalidCount) {
		this.description = description;		
		this.invalidRowsCount=invalidCount;
	}

	public LocalizedText getDescription() {
		return description;
	}
	
	public LocalizedText getName(){
		return name;
	}
	
	public boolean isValid() {
		return invalidRowsCount==0;
	}
	
	public int getInvalidRowsCount() {
		return invalidRowsCount;
	}

	public boolean isInheritable() {
		return false;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((description == null) ? 0 : description.hashCode());
		result = prime * result + invalidRowsCount;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DataValidationMetadata other = (DataValidationMetadata) obj;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (invalidRowsCount != other.invalidRowsCount)
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("DataValidationMetadata [description=");
		builder.append(description);
		builder.append(", name=");
		builder.append(name);
		builder.append(", invalidRowsCount=");
		builder.append(invalidRowsCount);
		builder.append("]");
		return builder.toString();
	}

	

}
