/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite;

import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.MultivaluedExpression;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;
import org.gcube.data.analysis.tabulardata.expression.leaf.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;

@XmlRootElement
public class ExternalReferenceExpression
extends CompositeExpression
implements MultivaluedExpression {
    private static final long serialVersionUID = 6558378164024433500L;
    private LeafExpression selectArgument;
    private Expression externalCondition;

    @Override
    public Operator getOperator() {
        return Operator.SELECT_IN;
    }

    @Override
    public DataType getReturnedDataType() throws NotEvaluableDataTypeException {
        return this.selectArgument.getReturnedDataType();
    }

    private ExternalReferenceExpression() {
    }

    public ExternalReferenceExpression(LeafExpression selectArgument, Expression externalCondition) {
        this.selectArgument = selectArgument;
        this.externalCondition = externalCondition;
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.selectArgument == null) {
            throw new MalformedExpressionException("Select argument cannot be null." + this);
        }
        if (this.externalCondition == null) {
            throw new MalformedExpressionException("Condition cannot be null." + this);
        }
        this.selectArgument.validate();
        this.externalCondition.validate();
    }

    public LeafExpression getSelectArgument() {
        return this.selectArgument;
    }

    public void setSelectArgument(LeafExpression selectArgument) {
        this.selectArgument = selectArgument;
    }

    public Expression getExternalCondition() {
        return this.externalCondition;
    }

    public void setExternalCondition(Expression externalCondition) {
        this.externalCondition = externalCondition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.externalCondition == null ? 0 : this.externalCondition.hashCode());
        result = 31 * result + (this.selectArgument == null ? 0 : this.selectArgument.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalReferenceExpression other = (ExternalReferenceExpression)obj;
        if (this.externalCondition == null ? other.externalCondition != null : !this.externalCondition.equals(other.externalCondition)) {
            return false;
        }
        return !(this.selectArgument == null ? other.selectArgument != null : !this.selectArgument.equals(other.selectArgument));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExternalReferenceExpression [selectArgument=");
        builder.append(this.selectArgument);
        builder.append(", externalCondition=");
        builder.append(this.externalCondition);
        builder.append("]");
        return builder.toString();
    }
}

