/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.column;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.gcube.data.analysis.tabulardata.metadata.ArrayListMetadataHolder;
import org.gcube.data.analysis.tabulardata.metadata.Metadata;
import org.gcube.data.analysis.tabulardata.metadata.MetadataHolder;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ViewColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ImmutableColumnRelationship;

@XmlRootElement(name="Column")
@XmlType(name="Column")
@XmlSeeAlso(value={Object.class, BooleanType.class, DateType.class, IntegerType.class, GeometryType.class, TextType.class, NamesMetadata.class, ViewColumnMetadata.class, DataLocaleMetadata.class, AnnotationColumnType.class, AttributeColumnType.class, CodeColumnType.class, CodeDescriptionColumnType.class, CodeNameColumnType.class, DimensionColumnType.class, IdColumnType.class, MeasureColumnType.class, TimeDimensionColumnType.class, ValidationColumnType.class, ValidationReferencesMetadata.class, DataValidationMetadata.class})
@XmlAccessorType(value=XmlAccessType.NONE)
public class Column
implements MetadataHolder<ColumnMetadata>,
Serializable {
    private static final long serialVersionUID = 222621862202261888L;
    @XmlAttribute
    private ColumnLocalId localId;
    @XmlAttribute
    private String name = null;
    @XmlElementRef
    private DataType dataType;
    @XmlElement(type=ImmutableColumnRelationship.class, name="Relationship")
    private ColumnRelationship relationship = null;
    @XmlElementRef
    private ColumnType columnType;
    private ArrayListMetadataHolder<ColumnMetadata> metadataDelegate = new ArrayListMetadataHolder();

    @XmlElementRefs(value={@XmlElementRef(type=NamesMetadata.class), @XmlElementRef(type=DataLocaleMetadata.class), @XmlElementRef(type=DescriptionsMetadata.class), @XmlElementRef(type=ViewColumnMetadata.class), @XmlElementRef(type=ValidationsMetadata.class)})
    private List<ColumnMetadata> getMetadata() {
        return this.metadataDelegate.metadata;
    }

    private Column() {
    }

    public Column(ColumnLocalId columnId, DataType dataType, ColumnType columnType) {
        this.setLocalId(columnId);
        this.setDataType(dataType);
        this.setColumnType(columnType);
    }

    public ColumnLocalId getLocalId() {
        return this.localId;
    }

    public void setLocalId(ColumnLocalId localId) {
        this.localId = localId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException("DataType cannot be null");
        }
        this.dataType = dataType;
    }

    public ColumnRelationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(ColumnRelationship columnRelationship) {
        this.relationship = columnRelationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public void setColumnType(ColumnType columnType) {
        if (columnType == null) {
            throw new IllegalArgumentException("ColumnType cannot be null");
        }
        this.columnType = columnType;
    }

    public <C extends ColumnMetadata> C getMetadata(Class<C> metadataType) {
        ColumnMetadata meta = (ColumnMetadata)this.metadataDelegate.getMetadata(metadataType);
        if (meta == null) {
            throw new NoSuchMetadataException(metadataType);
        }
        return (C)meta;
    }

    public void removeMetadata(Class<? extends ColumnMetadata> metadataType) {
        this.metadataDelegate.removeMetadata(metadataType);
    }

    public void setMetadata(ColumnMetadata metadata) {
        this.metadataDelegate.setMetadata((Metadata)metadata);
    }

    public Collection<ColumnMetadata> getAllMetadata() {
        return this.metadataDelegate.getAllMetadata();
    }

    public void setAllMetadata(Collection<ColumnMetadata> metadata) {
        this.metadataDelegate.setAllMetadata(metadata);
    }

    public void removeAllMetadata() {
        this.metadataDelegate.removeAllMetadata();
    }

    public boolean contains(Class<? extends ColumnMetadata> metadataType) {
        return this.metadataDelegate.contains(metadataType);
    }

    public boolean sameStructureAs(Column column) {
        if (!this.name.equals(column.name)) {
            return false;
        }
        if (!this.dataType.equals(column.dataType)) {
            return false;
        }
        if (this.relationship != null && !this.relationship.equals(column.relationship)) {
            return false;
        }
        return this.columnType.equals(column.columnType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localId == null ? 0 : this.localId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        return !(this.localId == null ? other.localId != null : !this.localId.equals(other.localId));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Column [localId=");
        builder.append(this.localId.getValue());
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", dataType=");
        builder.append(this.dataType);
        builder.append(", relationship=");
        builder.append(this.relationship);
        builder.append(", columnType=");
        builder.append(this.columnType);
        builder.append(", metadata=");
        builder.append(this.getAllMetadata());
        builder.append("]");
        return builder.toString();
    }
}

