/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.metadata.common;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.metadata.Locales;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;

@XmlRootElement(name="LocalizedText")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ImmutableLocalizedText
implements Serializable,
LocalizedText {
    private static final long serialVersionUID = 5174487267101638176L;
    @XmlAttribute(name="value")
    private String value;
    @XmlAttribute(name="locale")
    private String locale = null;

    private ImmutableLocalizedText() {
    }

    public ImmutableLocalizedText(String value) {
        this(value, "en");
    }

    public ImmutableLocalizedText(String value, String locale) {
        this.setLocale(locale);
        this.value = value;
    }

    private void setLocale(String locale) {
        if (!Locales.isValid(locale)) {
            throw new IllegalArgumentException("The provided string is not a valid ISO639-1 locale code");
        }
        this.locale = locale;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableLocalizedText other = (ImmutableLocalizedText)obj;
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalizedText [value=");
        builder.append(this.value);
        builder.append(", localeCode=");
        builder.append(this.locale);
        builder.append("]");
        return builder.toString();
    }
}

