/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.composite.BinaryExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.ExternalReferenceExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.MultipleArgumentsExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.UnaryExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.text.SubstringByIndex;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextReplaceMatchingRegex;
import org.gcube.data.analysis.tabulardata.expression.leaf.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

public class TableReferenceReplacer {
    private Expression currentExpression;
    private HashMap<TableId, List<ColumnReference>> referenceMap = new HashMap();
    private int totalReferenceCount = 0;

    public TableReferenceReplacer(Expression originalExpression) throws MalformedExpressionException {
        this.currentExpression = (Expression)originalExpression.clone();
        this.currentExpression.validate();
        this.scanForReferences(this.currentExpression);
        for (List<ColumnReference> references : this.referenceMap.values()) {
            this.totalReferenceCount += references.size();
        }
    }

    public Set<TableId> getTableIds() {
        return this.referenceMap.keySet();
    }

    public int getReferenceCount() {
        return this.totalReferenceCount;
    }

    public int getReferenceCount(TableId id) {
        try {
            return this.referenceMap.get(id).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public List<ColumnReference> getReferences(TableId id) {
        if (this.referenceMap.containsKey(id)) {
            return new ArrayList<ColumnReference>((Collection)this.referenceMap.get(id));
        }
        return Collections.emptyList();
    }

    public TableReferenceReplacer replaceColumnReference(ColumnReference toReplace, ColumnReference toSet) {
        List<ColumnReference> theList = this.referenceMap.get(toReplace.getTableId());
        if (theList != null) {
            ArrayList<Integer> found = new ArrayList<Integer>();
            for (int i = 0; i < theList.size(); ++i) {
                ColumnReference ref = theList.get(i);
                if (!toReplace.equals(ref)) continue;
                found.add(i);
            }
            for (Integer index : found) {
                ColumnReference ref = theList.remove(index);
                ref.setColumnId(toSet.getColumnId());
                ref.setTableId(toSet.getTableId());
                this.pinColumnReference(ref);
            }
        }
        return null;
    }

    public TableReferenceReplacer replaceTableId(TableId toReplace, TableId toSet) {
        if (this.referenceMap.containsKey(toReplace)) {
            for (ColumnReference ref : this.referenceMap.get(toReplace)) {
                ref.setTableId(toSet);
                this.pinColumnReference(ref);
            }
            this.referenceMap.remove(toReplace);
        }
        return this;
    }

    public TableReferenceReplacer replaceAllTableIds(TableId toSet) {
        for (TableId key : this.referenceMap.keySet()) {
            this.replaceTableId(key, toSet);
        }
        return this;
    }

    private void scanForReferences(Expression toScan) {
        if (toScan instanceof LeafExpression) {
            if (toScan instanceof ColumnReference) {
                this.pinColumnReference((ColumnReference)toScan);
            }
        } else if (toScan instanceof MultipleArgumentsExpression) {
            for (Expression expr : ((MultipleArgumentsExpression)toScan).getArguments()) {
                this.scanForReferences(expr);
            }
        } else if (toScan instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)toScan;
            this.scanForReferences(binary.getLeftArgument());
            this.scanForReferences(binary.getRightArgument());
        } else if (toScan instanceof UnaryExpression) {
            this.scanForReferences(((UnaryExpression)toScan).getArgument());
        } else if (toScan instanceof ExternalReferenceExpression) {
            this.scanForReferences(((ExternalReferenceExpression)toScan).getSelectArgument());
            this.scanForReferences(((ExternalReferenceExpression)toScan).getExternalCondition());
        } else if (toScan instanceof TextReplaceMatchingRegex) {
            this.scanForReferences(((TextReplaceMatchingRegex)toScan).getToCheckText());
            this.scanForReferences(((TextReplaceMatchingRegex)toScan).getRegexp());
            this.scanForReferences(((TextReplaceMatchingRegex)toScan).getReplacingValue());
        } else if (toScan instanceof SubstringByIndex) {
            this.scanForReferences(((SubstringByIndex)toScan).getSourceString());
            this.scanForReferences(((SubstringByIndex)toScan).getFromIndex());
            this.scanForReferences(((SubstringByIndex)toScan).getToIndex());
        }
    }

    private void pinColumnReference(ColumnReference ref) {
        TableId id = ref.getTableId();
        if (!this.referenceMap.containsKey(id)) {
            this.referenceMap.put(id, new ArrayList());
        }
        this.referenceMap.get(id).add(ref);
    }

    public Expression getExpression() {
        return this.currentExpression;
    }
}

