/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite.text;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.ExpressionCategory;
import org.gcube.data.analysis.tabulardata.expression.composite.BinaryExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class TextExpression
extends BinaryExpression
implements ExpressionCategory {
    private static final long serialVersionUID = 1038382757016138183L;
    private static final List<Class<? extends DataType>> allowedTypes = new ArrayList<Class<? extends DataType>>();
    private boolean caseSensitive = true;

    protected TextExpression() {
    }

    protected TextExpression(Expression leftArgument, Expression rightArgument) {
        super(leftArgument, rightArgument);
    }

    protected TextExpression(Expression leftArgument, Expression rightArgument, boolean caseSensitive) {
        this(leftArgument, rightArgument);
        this.caseSensitive = caseSensitive;
    }

    @Override
    public List<Class<? extends DataType>> allowedLeftDataTypes() {
        return allowedTypes;
    }

    @Override
    public List<Class<? extends DataType>> allowedRightDataTypes() {
        return allowedTypes;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.caseSensitive ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextExpression other = (TextExpression)obj;
        return this.caseSensitive == other.caseSensitive;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TextExpression [");
        builder.append(this.getLeftArgument() + " ");
        builder.append((Object)((Object)this.getOperator()) + " ");
        builder.append(this.isCaseSensitive() ? "CS " : "CI");
        builder.append(this.getRightArgument());
        builder.append("]");
        return builder.toString();
    }

    static {
        allowedTypes.add(TextType.class);
    }
}

