/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.gcube.data.analysis.tabulardata.expression.leaf.TypedColumnReference;
import org.gcube.data.analysis.tabulardata.metadata.ArrayListMetadataHolder;
import org.gcube.data.analysis.tabulardata.metadata.Metadata;
import org.gcube.data.analysis.tabulardata.metadata.MetadataHolder;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.column.PeriodTypeMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GcubeServiceReferenceMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.HarmonizationRuleTable;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ImportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TimePeriodTypeMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.VersionMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationshipImpl;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;

@XmlRootElement(name="Table")
@XmlType(name="Table")
@XmlSeeAlso(value={ImportMetadata.class, CodelistTableType.class, DatasetTableType.class, HierarchicalCodelistTableType.class, DatasetViewTableType.class, GenericTableType.class})
@XmlAccessorType(value=XmlAccessType.NONE)
public class Table
implements MetadataHolder<TableMetadata>,
Serializable {
    private static final long serialVersionUID = 8626095063616457984L;
    @XmlAttribute
    private TableId id = null;
    @XmlAttribute
    private String name = null;
    @XmlElementWrapper(name="Columns")
    @XmlElement(name="Column")
    private List<Column> columns = new ArrayList<Column>();
    private ArrayListMetadataHolder<TableMetadata> metadataDelegate = new ArrayListMetadataHolder();
    @XmlElementRef
    private TableType tableType;

    @XmlElementRefs(value={@XmlElementRef(type=DescriptionsMetadata.class), @XmlElementRef(type=DatasetViewTableMetadata.class), @XmlElementRef(type=ExportMetadata.class), @XmlElementRef(type=GenericMapMetadata.class), @XmlElementRef(type=GlobalDataValidationReportMetadata.class), @XmlElementRef(type=ImportMetadata.class), @XmlElementRef(type=NamesMetadata.class), @XmlElementRef(type=TimePeriodTypeMetadata.class), @XmlElementRef(type=ValidationsMetadata.class), @XmlElementRef(type=VersionMetadata.class), @XmlElementRef(type=TableDescriptorMetadata.class), @XmlElementRef(type=HarmonizationRuleTable.class), @XmlElementRef(type=GcubeServiceReferenceMetadata.class)})
    private List<TableMetadata> getMetadata() {
        return this.metadataDelegate.metadata;
    }

    private Table() {
    }

    public Table(TableType tableType) {
        this.setTableType(tableType);
    }

    public TableId getId() {
        return this.id;
    }

    public void setId(TableId id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public void setTableType(TableType tableType) {
        this.tableType = tableType;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public Column getColumnByName(String columnName) throws NoSuchColumnException {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : this.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            result.add(column);
        }
        if (result.size() > 1) {
            throw new RuntimeException("Found multiple column with the same name '" + columnName + "'.");
        }
        if (result.size() == 0) {
            throw new NoSuchColumnException(columnName, this);
        }
        return (Column)result.iterator().next();
    }

    public Column getColumnByLabel(String label) throws NoSuchColumnException {
        for (Column col : this.getColumns()) {
            if (col.getName().equals(label)) {
                return col;
            }
            try {
                for (LocalizedText localizedLabel : ((NamesMetadata)col.getMetadata(NamesMetadata.class)).getTexts()) {
                    if (!localizedLabel.getValue().equals(label)) continue;
                    return col;
                }
            }
            catch (NoSuchMetadataException e) {
            }
        }
        throw new NoSuchColumnException(label, this);
    }

    public Column getColumnById(ColumnLocalId columnId) throws NoSuchColumnException {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Column column : this.getColumns()) {
            if (!column.getLocalId().equals(columnId)) continue;
            columns.add(column);
        }
        if (columns.size() > 1) {
            throw new RuntimeException("Found multiple column with the same id '" + this.id + "'.");
        }
        if (columns.size() == 0) {
            throw new NoSuchColumnException(columnId, this);
        }
        return (Column)columns.iterator().next();
    }

    public List<Column> getColumnsByType(ColumnType ... columnTypes) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : this.getColumns()) {
            for (int i = 0; i < columnTypes.length; ++i) {
                if (!column.getColumnType().equals(columnTypes[i])) continue;
                result.add(column);
            }
        }
        return result;
    }

    public List<Column> getColumnsByType(Class<? extends ColumnType> ... columnTypes) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : this.getColumns()) {
            for (int i = 0; i < columnTypes.length; ++i) {
                if (!column.getColumnType().getClass().equals(columnTypes[i])) continue;
                result.add(column);
            }
        }
        return result;
    }

    public List<Column> getColumnsExceptTypes(ColumnType ... columnTypes) {
        ArrayList<Column> result = new ArrayList<Column>();
        ArrayList columnTypesList = new ArrayList();
        Collections.addAll(columnTypesList, columnTypes);
        for (Column column : this.getColumns()) {
            if (columnTypesList.contains(column.getColumnType())) continue;
            result.add(column);
        }
        return result;
    }

    public List<Column> getColumnsExceptTypes(Class<? extends ColumnType> ... columnTypes) {
        ArrayList columnTypesList = new ArrayList();
        Collections.addAll(columnTypesList, columnTypes);
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : this.getColumns()) {
            if (columnTypesList.contains(column.getColumnType().getClass())) continue;
            result.add(column);
        }
        return result;
    }

    public boolean hasRelationships() {
        for (Column column : this.getColumns()) {
            if (column.getRelationship() == null) continue;
            return true;
        }
        return false;
    }

    public List<TableRelationship> getCodelistRelationships() {
        ArrayList<TableRelationship> result = new ArrayList<TableRelationship>();
        for (Column column : this.getForeignKeyColumns()) {
            result.add(new TableRelationshipImpl(column.getRelationship(), this.getId(), column.getLocalId()));
        }
        return result;
    }

    public List<Column> getForeignKeyColumns() {
        ArrayList<Column> fkColumns = new ArrayList<Column>();
        for (Column column : this.getColumns()) {
            if (column.getRelationship() == null || column.contains(PeriodTypeMetadata.class)) continue;
            fkColumns.add(column);
        }
        return fkColumns;
    }

    public TypedColumnReference getColumnReference(Column column) {
        if (!this.columns.contains(column)) {
            throw new IllegalArgumentException("Table does not contain given column");
        }
        return new TypedColumnReference(this.id, column.getLocalId(), column.getDataType());
    }

    public <C extends TableMetadata> C getMetadata(Class<C> metadataType) {
        TableMetadata meta = (TableMetadata)this.metadataDelegate.getMetadata(metadataType);
        if (meta == null) {
            throw new NoSuchMetadataException(metadataType);
        }
        return (C)meta;
    }

    public void removeMetadata(Class<? extends TableMetadata> metadataType) {
        this.metadataDelegate.removeMetadata(metadataType);
    }

    public void setMetadata(TableMetadata metadata) {
        this.metadataDelegate.setMetadata((Metadata)metadata);
    }

    public Collection<TableMetadata> getAllMetadata() {
        return this.metadataDelegate.getAllMetadata();
    }

    public void setAllMetadata(Collection<TableMetadata> metadata) {
        this.metadataDelegate.setAllMetadata(metadata);
    }

    public void removeAllMetadata() {
        this.metadataDelegate.removeAllMetadata();
    }

    public boolean contains(Class<? extends TableMetadata> metadataType) {
        return this.metadataDelegate.contains(metadataType);
    }

    public boolean sameStructureAs(Table table) {
        if (!this.getTableType().equals(table.getTableType())) {
            return false;
        }
        if (this.getColumnsExceptTypes(ValidationColumnType.class).size() != table.getColumnsExceptTypes(ValidationColumnType.class).size()) {
            return false;
        }
        for (Column column : this.getColumnsExceptTypes(ValidationColumnType.class)) {
            boolean columnWithSameStructurePresent = false;
            for (Column otherTableColumn : table.getColumns()) {
                if (!column.sameStructureAs(otherTableColumn)) continue;
                columnWithSameStructurePresent = true;
            }
            if (columnWithSameStructurePresent) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.metadataDelegate == null ? 0 : this.metadataDelegate.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tableType == null ? 0 : this.tableType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Table other = (Table)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.metadataDelegate == null ? other.metadataDelegate != null : !this.metadataDelegate.equals(other.metadataDelegate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tableType == null ? other.tableType != null : !this.tableType.equals(other.tableType));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Table [\n\tid=");
        if (this.id != null) {
            builder.append(this.id.getValue());
        } else {
            builder.append("null");
        }
        builder.append(",\n\tname=");
        builder.append(this.name);
        builder.append(",\n\tcolumns=\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            builder.append(i + ":" + this.columns.get(i) + "\n");
        }
        builder.append(",\n\ttableType=");
        builder.append(this.tableType);
        builder.append(",\n\tgetAllMetadata()=");
        builder.append(this.getAllMetadata());
        builder.append("\n]");
        return builder.toString();
    }
}

