/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.time;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.model.ValueFormat;
import org.gcube.data.analysis.tabulardata.model.time.TimeConstants;

public enum PeriodType {
    DAY("Day", "DD Mon YYYY", "1 day"),
    MONTH("Month", "Mon YYYY", "1 month"),
    QUARTER("Quarter_of_year", "Qth \"Q\"uarter of YYYY", "3 month"),
    YEAR("Year", "YYYY", "1 year"),
    DECADE("Decade", "YYYYs", "10 year"),
    CENTURY("Century", "CCth century", "100 year");

    private static final int START_YEAR = 1700;
    private static final int END_YEAR = 2300;
    private static Map<PeriodType, List<PeriodType>> hierarchicalRelation;
    private static Map<PeriodType, List<ValueFormat>> acceptedTimeFormat;
    private String name;
    private String seriesSelectQuery;

    static {
        hierarchicalRelation = new HashMap<PeriodType, List<PeriodType>>();
        acceptedTimeFormat = new HashMap<PeriodType, List<ValueFormat>>();
        hierarchicalRelation.put(DAY, Arrays.asList(MONTH, QUARTER, YEAR, DECADE, CENTURY));
        hierarchicalRelation.put(MONTH, Arrays.asList(QUARTER, YEAR, DECADE, CENTURY));
        hierarchicalRelation.put(QUARTER, Arrays.asList(YEAR, DECADE, CENTURY));
        hierarchicalRelation.put(YEAR, Arrays.asList(DECADE, CENTURY));
        hierarchicalRelation.put(DECADE, Arrays.asList(CENTURY));
        acceptedTimeFormat.put(DAY, Arrays.asList(TimeConstants.ISO_DATE_ANY_SEP, TimeConstants.EUROPEAN_DATE));
        acceptedTimeFormat.put(MONTH, Arrays.asList(TimeConstants.ISO_MONTH));
        acceptedTimeFormat.put(QUARTER, Arrays.asList(TimeConstants.ISO_QUARTER));
        acceptedTimeFormat.put(YEAR, Arrays.asList(TimeConstants.ISO_YEAR));
        acceptedTimeFormat.put(DECADE, Arrays.asList(TimeConstants.DECADE_LITERAL_FORMAT, TimeConstants.DECADE_FORMAT));
        acceptedTimeFormat.put(CENTURY, Arrays.asList(TimeConstants.CENTURY_FORMAT));
    }

    private PeriodType(String name, String charRepresentation, String interval) {
        this.name = name;
        this.seriesSelectQuery = String.format("select get_%1$s_id(i), normalize_%1$s(i), to_char(i, '%2$s') from generate_series('</START>-01-01','</END>-12-31', '%3$s'::interval) i;", this.name.toLowerCase(), charRepresentation, interval);
    }

    public String getName() {
        return this.name;
    }

    public static PeriodType fromName(String name) {
        PeriodType[] periodTypeArray = PeriodType.values();
        int n = periodTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PeriodType periodType = periodTypeArray[n2];
            if (name.equals(periodType.getName())) {
                return periodType;
            }
            ++n2;
        }
        return null;
    }

    public List<ValueFormat> getAcceptedFormats() {
        return acceptedTimeFormat.get((Object)this);
    }

    public ValueFormat getTimeFormatById(String id) {
        for (ValueFormat tf : this.getAcceptedFormats()) {
            if (!tf.getId().equals(id)) continue;
            return tf;
        }
        return null;
    }

    public String getSeriesSelectQuery() {
        return this.seriesSelectQuery.replaceAll("</START>", "1700").replaceAll("</END>", "2300");
    }

    public static Map<PeriodType, List<PeriodType>> getHierarchicalRelation() {
        return hierarchicalRelation;
    }
}

