package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import static org.gcube.common.clients.exceptions.FaultDSL.again;

import java.util.List;
import java.util.UUID;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.td.commons.webservice.OperationManager;
import org.gcube.data.td.commons.webservice.exception.InvalidInvocationException;
import org.gcube.data.td.commons.webservice.exception.NoSuchColumnException;
import org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.td.commons.webservice.exception.OperationNotFoundException;
import org.gcube.data.td.commons.webservice.types.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperationManagerProxy implements OperationManagerProxy {

	private static Logger logger = LoggerFactory.getLogger(DefaultOperationManagerProxy.class);
	
	private final ProxyDelegate<OperationManager> delegate;
		
	public DefaultOperationManagerProxy(ProxyDelegate<OperationManager> config){
		this.delegate = config;
	}

	
	@Override
	public List<EligibleOperation> getCapabilities(final long tableId,
			final UUID columnId) throws NoSuchTabularResourceException,
			NoSuchColumnException {
		Call<OperationManager, List<EligibleOperation>> call = new Call<OperationManager, List<EligibleOperation>>() {

			@Override
			public List<EligibleOperation> call(OperationManager endpoint) throws Exception {
				return endpoint.getCapabilities(tableId, columnId);
			}
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			logger.error("error calling getCapabilities",e);
			throw again(e).asServiceException();
		}
	}


	@Override
	public List<EligibleOperation> getCapabilities(final long tabularResourceId)
			throws NoSuchTabularResourceException {
		Call<OperationManager, List<EligibleOperation>> call = new Call<OperationManager, List<EligibleOperation>>() {

			@Override
			public List<EligibleOperation> call(OperationManager endpoint) throws Exception {
				return endpoint.getCapabilities(tabularResourceId, null);
			}
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			logger.error("error calling getCapabilities",e);
			throw again(e).asServiceException();
		}
	}


	@Override
	public List<EligibleOperation> getCapabilities() {
		Call<OperationManager, List<EligibleOperation>> call = new Call<OperationManager, List<EligibleOperation>>() {

			@Override
			public List<EligibleOperation> call(OperationManager endpoint) throws Exception {
				return endpoint.getCapabilities(null, null);
			}
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			logger.error("error calling getCapabilities",e);
			throw again(e).asServiceException();
		}
	}


	@Override
	public TaskInfo execute(final OperationInvocation invocation,
			final long targetTabularResourceId)
			throws NoSuchTabularResourceException, InvalidInvocationException,
			OperationNotFoundException {
		Call<OperationManager, TaskInfo> call = new Call<OperationManager, TaskInfo>() {

			@Override
			public TaskInfo call(OperationManager endpoint) throws Exception {
				return endpoint.execute(invocation, targetTabularResourceId);
			}
		};
		try {
			return delegate.make(call);
		} catch (NoSuchTabularResourceException e) {
			logger.error("no tabular resource found with id "+targetTabularResourceId,e);
			throw e;
		} catch (InvalidInvocationException e) {
			logger.error("invalid invocation",e);
			throw e;
		} catch (Exception e) {
			logger.error("service error",e);
			throw again(e).asServiceException();
		}
	}

}
