package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.td.commons.webservice.TabularResourceManager;

public class DefaultTabularResourceManagerProxy implements TabularResourceManagerProxy {

	private final ProxyDelegate<TabularResourceManager> delegate;
		
	public DefaultTabularResourceManagerProxy(ProxyDelegate<TabularResourceManager> config){
		this.delegate = config;
	}

	@Override
	public Long createTabularResource() throws Exception {
		Call<TabularResourceManager, Long> call = new Call<TabularResourceManager, Long>() {

			@Override
			public Long call(TabularResourceManager endpoint) throws Exception {
				return endpoint.createTabularResource();
			}
		};
		return delegate.make(call);
	}	
	
}
