package org.gcube.data.analysis.tabulardata.clientlibrary;

import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.gcube.common.calls.jaxws.GcubeService;
import org.gcube.data.td.commons.webservice.HistoryManager;
import org.gcube.data.td.commons.webservice.OperationManager;
import org.gcube.data.td.commons.webservice.QueryManager;
import org.gcube.data.td.commons.webservice.TabularResourceManager;
import org.gcube.data.td.commons.webservice.TaskManager;

import static org.gcube.common.calls.jaxws.GcubeService.service;

public class Constants {

	/** Service name. */
	public static final String SERVICE_NAME = "TabularData";

	/** Service class. */
	public static final String SERVICE_CLASS = "DataAnalysis";
	
	public static final String CONTEX_SERVICE_NAME="tabular-data-manager";
	
	public static final int DEFAULT_TIMEOUT= (int) TimeUnit.SECONDS.toMillis(10);

	public static final String NAMESPACE = "http://gcube-system.org/namespaces/data/tabulardata";

	public static final QName TABULAR_RESOURCE_QNAME = new QName(org.gcube.data.td.commons.utils.Constants.TNS,TabularResourceManager.SERVICE_NAME);
	
	public static final QName OPERATION_QNAME = new QName(org.gcube.data.td.commons.utils.Constants.TNS,OperationManager.SERVICE_NAME);
	
	public static final QName HISTORY_QNAME = new QName(org.gcube.data.td.commons.utils.Constants.TNS,HistoryManager.SERVICE_NAME);
	
	public static final QName QUERY_QNAME = new QName(org.gcube.data.td.commons.utils.Constants.TNS,QueryManager.SERVICE_NAME);
	
	public static final QName TASK_QNAME = new QName(org.gcube.data.td.commons.utils.Constants.TNS,TaskManager.SERVICE_NAME);
	
	public static final GcubeService<TabularResourceManager> tabularResourceManager = service().withName(TABULAR_RESOURCE_QNAME).andInterface(TabularResourceManager.class);
	
	public static final GcubeService<OperationManager> operationManager =service().withName(OPERATION_QNAME).andInterface(OperationManager.class);
	
	public static final GcubeService<HistoryManager> historyManager =service().withName(HISTORY_QNAME).andInterface(HistoryManager.class);
	
	public static final GcubeService<QueryManager> queryManager =service().withName(QUERY_QNAME).andInterface(QueryManager.class);

	public static final GcubeService<TaskManager> taskManager =service().withName(TASK_QNAME).andInterface(TaskManager.class);

}
