/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import org.gcube.common.calls.jaxws.JAXWSUtils;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TabularResourceManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.TabularResourceManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTabularResourceManagerProxy
implements TabularResourceManagerProxy {
    private static Logger logger = LoggerFactory.getLogger(DefaultTabularResourceManagerProxy.class);
    private final ProxyDelegate<TabularResourceManager> delegate;

    public DefaultTabularResourceManagerProxy(ProxyDelegate<TabularResourceManager> config) {
        this.delegate = config;
    }

    public TabularResource createTabularResource() {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return endpoint.createTabularResource();
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public void remove(final long tabularResourceId) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, JAXWSUtils.Empty> call = new Call<TabularResourceManager, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(TabularResourceManager endpoint) throws Exception {
                endpoint.remove(tabularResourceId);
                return new JAXWSUtils.Empty();
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            logger.error("no tabular resource found with id {}", (Object)tabularResourceId);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TabularResource cloneTabularResource(final long tabularResourceId, final Long lastTableId) throws NoSuchTabularResourceException, NoSuchTableException {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return endpoint.cloneTabularResource(tabularResourceId, lastTableId);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            logger.error("no tabular resource found with id {}", (Object)tabularResourceId);
            throw e;
        }
        catch (NoSuchTableException e) {
            logger.error("table with id {} not found, erorr on history", (Object)lastTableId);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public List<TabularResource> getAllTabularResources() {
        Call<TabularResourceManager, List<TabularResource>> call = new Call<TabularResourceManager, List<TabularResource>>(){

            public List<TabularResource> call(TabularResourceManager endpoint) throws Exception {
                return endpoint.getAllTabularResources();
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TabularResource updateTabularResource(final TabularResource tabularResource) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return endpoint.updateTabularResource(tabularResource);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (NoSuchTabularResourceException st) {
            throw st;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TabularResource getTabularResource(final long id) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return endpoint.getTabularResource(id);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            logger.error("no tabular resource found with id {}", (Object)id);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TabularResource share(final Long tabularResourceId, final AuthorizationToken ... authTokens) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return (TabularResource)endpoint.share((Object)tabularResourceId, authTokens);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (NoSuchTabularResourceException nte) {
            throw nte;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TabularResource unshare(final Long tabularResourceId, final AuthorizationToken ... authTokens) throws SecurityException, NoSuchTabularResourceException {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return (TabularResource)endpoint.unshare((Object)tabularResourceId, authTokens);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (NoSuchTabularResourceException nte) {
            throw nte;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public List<TabularResource> getTabularResourcesByType(final String type) {
        Call<TabularResourceManager, List<TabularResource>> call = new Call<TabularResourceManager, List<TabularResource>>(){

            public List<TabularResource> call(TabularResourceManager endpoint) throws Exception {
                return endpoint.getTabularResourcesByType(type);
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

