/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.RuleManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.rules.RuleScope;
import org.gcube.data.analysis.tabulardata.commons.rules.types.RuleColumnType;
import org.gcube.data.analysis.tabulardata.commons.webservice.RuleManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.RuleDescription;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuleManagerProxy
implements RuleManagerProxy {
    ProxyDelegate<RuleManager> delegate;
    private static Logger logger = LoggerFactory.getLogger(DefaultRuleManagerProxy.class);

    public DefaultRuleManagerProxy(ProxyDelegate<RuleManager> config) {
        this.delegate = config;
    }

    public long saveColumnRule(final String name, final String description, final Expression rule, final RuleColumnType columnType) {
        Call<RuleManager, Long> call = new Call<RuleManager, Long>(){

            public Long call(RuleManager endpoint) throws Exception {
                return endpoint.saveColumnRule(name, description, rule, columnType);
            }
        };
        try {
            return (Long)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            logger.error("error saving rule");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public List<RuleDescription> getRules() {
        Call<RuleManager, List<RuleDescription>> call = new Call<RuleManager, List<RuleDescription>>(){

            public List<RuleDescription> call(RuleManager endpoint) throws Exception {
                return endpoint.getRules();
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            logger.error("error saving template");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public List<RuleDescription> getRulesByScope(final RuleScope scope) {
        Call<RuleManager, List<RuleDescription>> call = new Call<RuleManager, List<RuleDescription>>(){

            public List<RuleDescription> call(RuleManager endpoint) throws Exception {
                return endpoint.getRulesByScope(scope);
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            logger.error("error saving template");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

