/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import org.gcube.common.calls.jaxws.JAXWSUtils;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TabularResourceManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.TabularResourceManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResource;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResourceType;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.notifications.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTabularResourceManagerProxy
implements TabularResourceManagerProxy {
    private static Logger logger = LoggerFactory.getLogger(DefaultTabularResourceManagerProxy.class);
    private final ProxyDelegate<TabularResourceManager> delegate;

    public DefaultTabularResourceManagerProxy(ProxyDelegate<TabularResourceManager> config) {
        this.delegate = config;
    }

    @Override
    public TabularResource createTabularResource(final TabularResourceType type) {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return endpoint.createTabularResource(type);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public void remove(final long tabularResourceId) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, JAXWSUtils.Empty> call = new Call<TabularResourceManager, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(TabularResourceManager endpoint) throws Exception {
                endpoint.remove(tabularResourceId);
                return new JAXWSUtils.Empty();
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            logger.error("no tabular resource found with id {}", (Object)tabularResourceId);
            throw e;
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<TabularResource> getAllTabularResources() {
        Call<TabularResourceManager, List<TabularResource>> call = new Call<TabularResourceManager, List<TabularResource>>(){

            public List<TabularResource> call(TabularResourceManager endpoint) throws Exception {
                return endpoint.getAllTabularResources();
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public TabularResource updateTabularResource(final TabularResource tabularResource) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return endpoint.updateTabularResource(tabularResource);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchTabularResourceException st) {
            throw st;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public TabularResource getTabularResource(final long id) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return endpoint.getTabularResource(id);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            logger.error("no tabular resource found with id {}", (Object)id);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TabularResource share(final Long tabularResourceId, final AuthorizationToken ... authTokens) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return (TabularResource)endpoint.share((Object)tabularResourceId, authTokens);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException se) {
            throw new SecurityException(se);
        }
        catch (NoSuchTabularResourceException nte) {
            throw nte;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TabularResource unshare(final Long tabularResourceId, final AuthorizationToken ... authTokens) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, TabularResource> call = new Call<TabularResourceManager, TabularResource>(){

            public TabularResource call(TabularResourceManager endpoint) throws Exception {
                return (TabularResource)endpoint.unshare((Object)tabularResourceId, authTokens);
            }
        };
        try {
            return (TabularResource)this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException nte) {
            throw nte;
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<TabularResource> getTabularResourcesByType(final String type) {
        Call<TabularResourceManager, List<TabularResource>> call = new Call<TabularResourceManager, List<TabularResource>>(){

            public List<TabularResource> call(TabularResourceManager endpoint) throws Exception {
                return endpoint.getTabularResourcesByType(type);
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<Notification> getNotificationPerTabularResource(long id) {
        return null;
    }

    @Override
    public List<Notification> getNotificationPerUser() {
        return null;
    }

    @Override
    public void cleanDatabase() {
        Call<TabularResourceManager, JAXWSUtils.Empty> call = new Call<TabularResourceManager, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(TabularResourceManager endpoint) throws Exception {
                endpoint.cleanDatabase();
                return new JAXWSUtils.Empty();
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

