/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.ExternalResourceManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.webservice.ExternalResourceManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.resources.ResourceDescriptor;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;

public class DefaultExternalResourceManagerProxy
implements ExternalResourceManagerProxy {
    private final ProxyDelegate<ExternalResourceManager> delegate;

    public DefaultExternalResourceManagerProxy(ProxyDelegate<ExternalResourceManager> config) {
        this.delegate = config;
    }

    @Override
    public List<ResourceDescriptor> getResourcePerTabularResource(final long tabularResourceId) throws NoSuchTabularResourceException {
        Call<ExternalResourceManager, List<ResourceDescriptor>> call = new Call<ExternalResourceManager, List<ResourceDescriptor>>(){

            public List<ResourceDescriptor> call(ExternalResourceManager endpoint) throws Exception {
                return endpoint.getResourcePerTabularResource(tabularResourceId);
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchTabularResourceException nte) {
            throw nte;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<ResourceDescriptor> getResourcePerTabularResourceAndType(final long tabularResourceId, final ResourceType type) throws NoSuchTabularResourceException {
        Call<ExternalResourceManager, List<ResourceDescriptor>> call = new Call<ExternalResourceManager, List<ResourceDescriptor>>(){

            public List<ResourceDescriptor> call(ExternalResourceManager endpoint) throws Exception {
                return endpoint.getResourcePerTabularResourceAndType(tabularResourceId, type);
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchTabularResourceException nte) {
            throw nte;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public ResourceDescriptor removeResource(final long resourceId) {
        Call<ExternalResourceManager, ResourceDescriptor> call = new Call<ExternalResourceManager, ResourceDescriptor>(){

            public ResourceDescriptor call(ExternalResourceManager endpoint) throws Exception {
                return endpoint.removeResource(resourceId);
            }
        };
        try {
            return (ResourceDescriptor)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

