/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.commons;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.wps.FormatDocument;
import org.n52.wps.GeneratorDocument;
import org.n52.wps.ParserDocument;
import org.n52.wps.PropertyDocument;
import org.n52.wps.RepositoryDocument;
import org.n52.wps.WPSConfigurationDocument;
import org.n52.wps.impl.WPSConfigurationDocumentImpl;

public class WPSConfig
implements Serializable {
    private static transient WPSConfig wpsConfig;
    private static transient WPSConfigurationDocumentImpl.WPSConfigurationImpl wpsConfigXMLBeans;
    private static transient Logger LOGGER;
    protected final PropertyChangeSupport propertyChangeSupport;
    public static final String WPSCONFIG_PROPERTY_EVENT_NAME = "WPSConfigUpdate";
    public static final String WPSCAPABILITIES_SKELETON_PROPERTY_EVENT_NAME = "WPSCapabilitiesUpdate";

    private WPSConfig(String wpsConfigPath) throws XmlException, IOException {
        wpsConfigXMLBeans = (WPSConfigurationDocumentImpl.WPSConfigurationImpl)WPSConfigurationDocument.Factory.parse((File)new File(wpsConfigPath)).getWPSConfiguration();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    private WPSConfig(InputStream resourceAsStream) throws XmlException, IOException {
        wpsConfigXMLBeans = (WPSConfigurationDocumentImpl.WPSConfigurationImpl)WPSConfigurationDocument.Factory.parse((InputStream)resourceAsStream).getWPSConfiguration();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void notifyListeners() {
        this.propertyChangeSupport.firePropertyChange(WPSCONFIG_PROPERTY_EVENT_NAME, null, null);
    }

    private synchronized void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(wpsConfigXMLBeans.xmlText());
    }

    private synchronized void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
        try {
            String wpsConfigXMLBeansAsXml = (String)oos.readObject();
            XmlObject configXmlObject = XmlObject.Factory.parse((String)wpsConfigXMLBeansAsXml);
            WPSConfigurationDocument configurationDocument = WPSConfigurationDocument.Factory.newInstance();
            configurationDocument.addNewWPSConfiguration().set(configXmlObject);
            wpsConfig = new WPSConfig(new StringBufferInputStream(configurationDocument.xmlText()));
        }
        catch (XmlException e) {
            LOGGER.error((Object)e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    public static void forceInitialization(String configPath) throws XmlException, IOException {
        PropertyChangeListener[] listeners = new PropertyChangeListener[]{};
        if (wpsConfig != null) {
            listeners = WPSConfig.wpsConfig.propertyChangeSupport.getPropertyChangeListeners();
        }
        wpsConfig = new WPSConfig(configPath);
        for (int i = listeners.length - 1; i >= 0; --i) {
            WPSConfig.wpsConfig.propertyChangeSupport.addPropertyChangeListener(listeners[i]);
        }
        WPSConfig.wpsConfig.propertyChangeSupport.firePropertyChange(WPSCONFIG_PROPERTY_EVENT_NAME, null, wpsConfig);
        LOGGER.info((Object)"Configuration Reloaded, Listeners informed");
    }

    public static void forceInitialization(InputStream stream) throws XmlException, IOException {
        PropertyChangeListener[] listeners = new PropertyChangeListener[]{};
        if (wpsConfig != null) {
            listeners = WPSConfig.wpsConfig.propertyChangeSupport.getPropertyChangeListeners();
        }
        wpsConfig = new WPSConfig(stream);
        for (int i = listeners.length - 1; i >= 0; --i) {
            WPSConfig.wpsConfig.propertyChangeSupport.addPropertyChangeListener(listeners[i]);
        }
        WPSConfig.wpsConfig.propertyChangeSupport.firePropertyChange(WPSCONFIG_PROPERTY_EVENT_NAME, null, wpsConfig);
        LOGGER.info((Object)"Configuration Reloaded, Listeners informed");
    }

    public static WPSConfig getInstance() {
        if (wpsConfig == null) {
            return WPSConfig.getInstance(WPSConfig.getConfigPath());
        }
        return wpsConfig;
    }

    public static WPSConfig getInstance(String path) {
        if (wpsConfig == null) {
            try {
                wpsConfig = new WPSConfig(path);
            }
            catch (XmlException e) {
                LOGGER.error((Object)("Failed to initialize WPS. Reason: " + e.getMessage()));
                throw new RuntimeException("Failed to initialize WPS. Reason: " + e.getMessage());
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to initialize WPS. Reason: " + e.getMessage()));
                throw new RuntimeException("Failed to initialize WPS. Reason: " + e.getMessage());
            }
        }
        return wpsConfig;
    }

    public static String getConfigPath() {
        String configPath = WPSConfig.tryToGetPathFromClassPath();
        File file = null;
        if (configPath != null && (file = new File(configPath)).exists()) {
            return configPath;
        }
        configPath = WPSConfig.tryToGetPathFromWebAppTarget();
        if (configPath != null) {
            file = new File(configPath);
            if (configPath != null && file.exists()) {
                return configPath;
            }
        }
        if ((configPath = WPSConfig.tryToGetPathFromWebAppSource()) != null) {
            file = new File(configPath);
            if (configPath != null && file.exists()) {
                return configPath;
            }
        }
        if ((configPath = WPSConfig.tryToGetPathViaWebAppPath()) != null) {
            file = new File(configPath);
            if (configPath != null && file.exists()) {
                return configPath;
            }
        }
        if ((configPath = WPSConfig.tryToGetPathLastResort()) != null) {
            file = new File(configPath);
            if (configPath != null && file.exists()) {
                return configPath;
            }
        }
        throw new RuntimeException("Could find and load wps_config.xml");
    }

    public static String tryToGetPathFromClassPath() {
        URL configPathURL = WPSConfig.class.getClassLoader().getResource("wps_config.xml");
        if (configPathURL != null) {
            String config = configPathURL.getFile();
            config = URLDecoder.decode(config);
            return config;
        }
        return null;
    }

    public static String tryToGetPathFromWebAppTarget() {
        String domain = WPSConfig.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        int index1 = domain.indexOf("52n-wps-parent");
        if (index1 > 0) {
            String path = URLDecoder.decode(domain.substring(0, index1 + 14));
            File f = new File(path = path + File.separator + "52n-wps-webapp" + File.separator + "target");
            String[] dirs = f.getAbsoluteFile().list();
            if (dirs != null) {
                for (String dir : dirs) {
                    if (!dir.startsWith("52n-wps-webapp") || dir.endsWith(".war")) continue;
                    path = path + File.separator + dir + File.separator + "config/wps_config.xml";
                }
                return path;
            }
        }
        return null;
    }

    public static String tryToGetPathFromWebAppSource() {
        String domain = WPSConfig.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        int index1 = domain.indexOf("52n-wps-parent");
        if (index1 > 0) {
            String path = URLDecoder.decode(domain.substring(0, index1 + 14));
            File f = new File(path = path + File.separator + "52n-wps-webapp");
            String[] dirs = f.getAbsoluteFile().list();
            if (dirs != null) {
                for (String dir : dirs) {
                    if (!dir.equals("src")) continue;
                    path = path + File.separator + dir + File.separator + "main" + File.separator + "webapp" + File.separator + "config" + File.separator + "wps_config.xml";
                }
                if (!new File(path).exists()) {
                    return null;
                }
                return path;
            }
        }
        return null;
    }

    public static String tryToGetPathViaWebAppPath() {
        String domain = WPSConfig.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        int index = domain.indexOf("WEB-INF");
        if (index > 0) {
            String substring = domain.substring(0, index);
            if (!substring.endsWith("/")) {
                substring = substring + "/";
            }
            substring = substring + "config/wps_config.xml";
            return substring;
        }
        return null;
    }

    public static String tryToGetPathLastResort() {
        String[] dirs;
        String domain = WPSConfig.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File classDir = new File(domain);
        File projectRoot = classDir.getParentFile().getParentFile().getParentFile();
        String path = projectRoot.getAbsolutePath();
        for (String dir : dirs = projectRoot.getAbsoluteFile().list()) {
            if (!dir.startsWith("52n-wps-webapp") || dir.endsWith(".war")) continue;
            path = path + File.separator + dir + File.separator + "src" + File.separator + "main" + File.separator + "webapp" + File.separator + "config" + File.separator + "wps_config.xml";
        }
        LOGGER.info((Object)path);
        return path;
    }

    public WPSConfigurationDocumentImpl.WPSConfigurationImpl getWPSConfig() {
        return wpsConfigXMLBeans;
    }

    public ParserDocument.Parser[] getRegisteredParser() {
        return wpsConfigXMLBeans.getDatahandlers().getParserList().getParserArray();
    }

    public ParserDocument.Parser[] getActiveRegisteredParser() {
        ParserDocument.Parser[] parsers = this.getRegisteredParser();
        ArrayList<ParserDocument.Parser> activeParsers = new ArrayList<ParserDocument.Parser>();
        for (int i = 0; i < parsers.length; ++i) {
            if (!parsers[i].getActive()) continue;
            activeParsers.add(parsers[i]);
        }
        ParserDocument.Parser[] parArr = new ParserDocument.Parser[]{};
        return activeParsers.toArray(parArr);
    }

    public GeneratorDocument.Generator[] getRegisteredGenerator() {
        return wpsConfigXMLBeans.getDatahandlers().getGeneratorList().getGeneratorArray();
    }

    public GeneratorDocument.Generator[] getActiveRegisteredGenerator() {
        GeneratorDocument.Generator[] generators = this.getRegisteredGenerator();
        ArrayList<GeneratorDocument.Generator> activeGenerators = new ArrayList<GeneratorDocument.Generator>();
        for (int i = 0; i < generators.length; ++i) {
            if (!generators[i].getActive()) continue;
            activeGenerators.add(generators[i]);
        }
        GeneratorDocument.Generator[] genArr = new GeneratorDocument.Generator[]{};
        return activeGenerators.toArray(genArr);
    }

    public RepositoryDocument.Repository[] getRegisterdAlgorithmRepositories() {
        return wpsConfigXMLBeans.getAlgorithmRepositoryList().getRepositoryArray();
    }

    public PropertyDocument.Property[] getPropertiesForGeneratorClass(String className) {
        GeneratorDocument.Generator[] generators = wpsConfigXMLBeans.getDatahandlers().getGeneratorList().getGeneratorArray();
        for (int i = 0; i < generators.length; ++i) {
            GeneratorDocument.Generator generator = generators[i];
            if (!generator.getClassName().equals(className)) continue;
            return generator.getPropertyArray();
        }
        return (PropertyDocument.Property[])Array.newInstance(PropertyDocument.Property.class, 0);
    }

    public FormatDocument.Format[] getFormatsForGeneratorClass(String className) {
        GeneratorDocument.Generator[] generators = wpsConfigXMLBeans.getDatahandlers().getGeneratorList().getGeneratorArray();
        for (int i = 0; i < generators.length; ++i) {
            GeneratorDocument.Generator generator = generators[i];
            if (!generator.getClassName().equals(className)) continue;
            return generator.getFormatArray();
        }
        return (FormatDocument.Format[])Array.newInstance(FormatDocument.Format.class, 0);
    }

    public PropertyDocument.Property[] getPropertiesForParserClass(String className) {
        ParserDocument.Parser[] parsers = wpsConfigXMLBeans.getDatahandlers().getParserList().getParserArray();
        for (int i = 0; i < parsers.length; ++i) {
            ParserDocument.Parser parser = parsers[i];
            if (!parser.getClassName().equals(className)) continue;
            return parser.getPropertyArray();
        }
        return (PropertyDocument.Property[])Array.newInstance(PropertyDocument.Property.class, 0);
    }

    public FormatDocument.Format[] getFormatsForParserClass(String className) {
        ParserDocument.Parser[] parsers = wpsConfigXMLBeans.getDatahandlers().getParserList().getParserArray();
        for (int i = 0; i < parsers.length; ++i) {
            ParserDocument.Parser parser = parsers[i];
            if (!parser.getClassName().equals(className)) continue;
            return parser.getFormatArray();
        }
        return (FormatDocument.Format[])Array.newInstance(FormatDocument.Format.class, 0);
    }

    public boolean isParserActive(String className) {
        ParserDocument.Parser[] activeParser = this.getActiveRegisteredParser();
        for (int i = 0; i < activeParser.length; ++i) {
            ParserDocument.Parser parser = activeParser[i];
            if (!parser.getClassName().equals(className)) continue;
            return parser.getActive();
        }
        return false;
    }

    public boolean isGeneratorActive(String className) {
        GeneratorDocument.Generator[] generators = this.getActiveRegisteredGenerator();
        for (int i = 0; i < generators.length; ++i) {
            GeneratorDocument.Generator generator = generators[i];
            if (!generator.getClassName().equals(className)) continue;
            return generator.getActive();
        }
        return false;
    }

    public boolean isRepositoryActive(String className) {
        RepositoryDocument.Repository[] repositories = this.getRegisterdAlgorithmRepositories();
        for (int i = 0; i < repositories.length; ++i) {
            RepositoryDocument.Repository repository = repositories[i];
            if (!repository.getClassName().equals(className)) continue;
            return repository.getActive();
        }
        return false;
    }

    public PropertyDocument.Property[] getPropertiesForRepositoryClass(String className) {
        RepositoryDocument.Repository[] repositories = this.getRegisterdAlgorithmRepositories();
        for (int i = 0; i < repositories.length; ++i) {
            RepositoryDocument.Repository repository = repositories[i];
            if (!repository.getClassName().equals(className)) continue;
            return repository.getPropertyArray();
        }
        return (PropertyDocument.Property[])Array.newInstance(PropertyDocument.Property.class, 0);
    }

    public PropertyDocument.Property getPropertyForKey(PropertyDocument.Property[] properties, String key) {
        for (PropertyDocument.Property property : properties) {
            if (!property.getName().equalsIgnoreCase(key)) continue;
            return property;
        }
        return null;
    }

    static {
        LOGGER = Logger.getLogger(WPSConfig.class);
    }
}

