/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.httpclient.HttpException;
import org.n52.wps.PropertyDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.n52.wps.io.datahandler.generator.GeoServerUploader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GeoserverWFSGenerator
extends AbstractGenerator {
    private String username;
    private String password;
    private String host;
    private String port;

    public GeoserverWFSGenerator() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
        for (PropertyDocument.Property property : this.properties = WPSConfig.getInstance().getPropertiesForGeneratorClass(this.getClass().getName())) {
            if (property.getName().equalsIgnoreCase("Geoserver_username")) {
                this.username = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Geoserver_password")) {
                this.password = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Geoserver_host")) {
                this.host = property.getStringValue();
            }
            if (!property.getName().equalsIgnoreCase("Geoserver_port")) continue;
            this.port = property.getStringValue();
        }
        if (this.port == null) {
            this.port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
        }
        for (String supportedFormat : this.supportedFormats) {
            if (!supportedFormat.equals("text/xml")) continue;
            this.supportedFormats.remove(supportedFormat);
        }
    }

    @Override
    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        ByteArrayInputStream stream = null;
        try {
            Document doc = this.storeLayer(data);
            DOMSource domSource = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            sw.flush();
            sw.close();
            stream = new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Error generating WFS output. Reason: " + ex);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error generating WFS output. Reason: " + e);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException("Error generating WFS output. Reason: " + e);
        }
        return stream;
    }

    private Document storeLayer(IData coll) throws HttpException, IOException, ParserConfigurationException {
        GTVectorDataBinding gtData = (GTVectorDataBinding)coll;
        File file = null;
        try {
            GenericFileData fileData = new GenericFileData(gtData.getPayload());
            file = fileData.getBaseFile(true);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new RuntimeException("Error generating shp file for storage in WFS. Reason: " + e1);
        }
        String path = file.getAbsolutePath();
        String baseName = path.substring(0, path.length() - ".shp".length());
        File shx = new File(baseName + ".shx");
        File dbf = new File(baseName + ".dbf");
        File prj = new File(baseName + ".prj");
        File zipped = IOUtils.zip(file, shx, dbf, prj);
        String layerName = zipped.getName();
        layerName = layerName + "_" + UUID.randomUUID();
        GeoServerUploader geoserverUploader = new GeoServerUploader(this.username, this.password, this.host, this.port);
        String result = geoserverUploader.createWorkspace();
        System.out.println(result);
        System.out.println("");
        result = geoserverUploader.uploadShp(zipped, layerName);
        System.out.println(result);
        String capabilitiesLink = "http://" + this.host + ":" + this.port + "/geoserver/wfs?Service=WFS&Request=GetCapabilities&Version=1.1.0";
        zipped.delete();
        file.delete();
        shx.delete();
        dbf.delete();
        prj.delete();
        Document doc = this.createXML("N52:" + file.getName().subSequence(0, file.getName().length() - 4), capabilitiesLink);
        return doc;
    }

    private Document createXML(String layerName, String getCapabilitiesLink) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        Element root = doc.createElement("OWSResponse");
        root.setAttribute("type", "WFS");
        Element resourceIDElement = doc.createElement("ResourceID");
        resourceIDElement.appendChild(doc.createTextNode(layerName));
        root.appendChild(resourceIDElement);
        Element getCapabilitiesLinkElement = doc.createElement("GetCapabilitiesLink");
        getCapabilitiesLinkElement.appendChild(doc.createTextNode(getCapabilitiesLink));
        root.appendChild(getCapabilitiesLinkElement);
        doc.appendChild(root);
        return doc;
    }
}

