/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.MaxFeaturesIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxSimpleFeatureCollection
extends DecoratingSimpleFeatureCollection {
    SimpleFeatureCollection delegate;
    long start;
    long max;

    public MaxSimpleFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, long max) {
        this(DataUtilities.simple(delegate), 0L, max);
    }

    public MaxSimpleFeatureCollection(SimpleFeatureCollection delegate, long max) {
        this(delegate, 0L, max);
    }

    public MaxSimpleFeatureCollection(SimpleFeatureCollection delegate, long start, long max) {
        super(delegate);
        this.delegate = delegate;
        this.start = start;
        this.max = max;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), this.features());
    }

    @Override
    public SimpleFeatureIterator features() {
        return new DelegateSimpleFeatureIterator(this, this.iterator());
    }

    public void close(SimpleFeatureIterator close) {
        close.close();
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        return new MaxFeaturesIterator<SimpleFeature>(this.delegate.iterator(), this.start, this.max);
    }

    @Override
    public void close(Iterator<SimpleFeature> close) {
        Iterator iterator = ((MaxFeaturesIterator)close).getDelegate();
        this.delegate.close(iterator);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = this.delegate.size();
        if ((long)size < this.start) {
            return 0;
        }
        return (int)Math.min((long)size - this.start, this.max);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty() || this.max == 0L;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray(Object[] a) {
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object[] objectArray = list.toArray(a);
            return objectArray;
        }
        finally {
            this.close(i);
        }
    }

    @Override
    public boolean add(SimpleFeature o) {
        long size = this.delegate.size();
        if (size < this.max) {
            return this.delegate.add(o);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            changed |= this.add((SimpleFeature)i.next());
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference(DataUtilities.bounds(this));
    }
}

