/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.util.Utilities;
import org.geotools.xml.Encoder;
import org.geotools.xml.Parser;
import org.geotools.xml.SchemaLocationResolver;
import org.geotools.xml.SchemaLocator;
import org.geotools.xml.XSD;
import org.geotools.xml.impl.PicoMap;
import org.geotools.xs.XSConfiguration;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;

public abstract class Configuration {
    private final XSD xsd;
    private final List dependencies;
    private final Set properties;
    private final MutablePicoContainer context;

    public Configuration(XSD xsd) {
        this.xsd = xsd;
        this.dependencies = Collections.synchronizedList(new ArrayList());
        if (!(this instanceof XSConfiguration)) {
            this.dependencies.add(new XSConfiguration());
        }
        this.properties = Collections.synchronizedSet(new HashSet());
        this.context = new DefaultPicoContainer();
    }

    public XSD getXSD() {
        return this.xsd;
    }

    public final List getDependencies() {
        return this.dependencies;
    }

    public final Set getProperties() {
        return this.properties;
    }

    public final boolean hasProperty(QName property) {
        for (Configuration configuration : this.allDependencies()) {
            if (!configuration.getProperties().contains(property)) continue;
            return true;
        }
        return false;
    }

    public final List allDependencies() {
        LinkedList<Configuration> unpacked = new LinkedList<Configuration>();
        Stack<Configuration> stack = new Stack<Configuration>();
        stack.push(this);
        while (!stack.isEmpty()) {
            Configuration c = (Configuration)stack.pop();
            if (unpacked.contains(c)) continue;
            unpacked.addFirst(c);
            stack.addAll(c.getDependencies());
        }
        if (unpacked.size() < 2) {
            return unpacked;
        }
        DepGraph g = new DepGraph();
        for (Configuration c : unpacked) {
            for (Configuration d : c.getDependencies()) {
                g.addEdge(c, d);
            }
        }
        PriorityQueue<DepNode> q = new PriorityQueue<DepNode>(g.nodes.size(), new Comparator<DepNode>(){

            @Override
            public int compare(DepNode o1, DepNode o2) {
                return Integer.valueOf(o1.outgoing().size()).compareTo(o2.outgoing().size());
            }
        });
        for (DepNode n : g.nodes.values()) {
            q.add(n);
        }
        unpacked = new LinkedList();
        while (!q.isEmpty()) {
            DepNode n = (DepNode)q.remove();
            if (n.outgoing().size() != 0) {
                throw new IllegalStateException();
            }
            unpacked.add(n.config);
            for (DepNode i : n.incoming()) {
                g.removeEdge(i.config, n.config);
                q.removeAll(Collections.singletonList(i));
                q.add(i);
            }
        }
        return unpacked;
    }

    protected void addDependency(Configuration dependency) {
        if (this.dependencies.contains(dependency)) {
            return;
        }
        this.dependencies.add(dependency);
    }

    public final String getNamespaceURI() {
        return this.getXSD().getNamespaceURI();
    }

    public final String getSchemaFileURL() {
        return this.getXSD().getSchemaLocation();
    }

    public final XSDSchemaLocationResolver getSchemaLocationResolver() {
        return new SchemaLocationResolver(this.xsd);
    }

    public final XSDSchemaLocator getSchemaLocator() {
        return new SchemaLocator(this.xsd);
    }

    public XSDSchema schema() {
        try {
            return this.getXSD().getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final MutablePicoContainer getContext() {
        return this.context;
    }

    public final MutablePicoContainer setupBindings(MutablePicoContainer container) {
        for (Configuration dependency : this.allDependencies()) {
            dependency.registerBindings(container);
        }
        container = container.makeChildContainer();
        this.configureBindings(container);
        return container;
    }

    public final Map setupBindings() {
        HashMap bindings = new HashMap();
        PicoMap container = new PicoMap(bindings);
        for (Configuration dependency : this.allDependencies()) {
            dependency.registerBindings(bindings);
            dependency.registerBindings(container);
        }
        for (Configuration dependency : this.allDependencies()) {
            dependency.configureBindings(bindings);
            dependency.configureBindings(container);
        }
        return bindings;
    }

    public final void setupParser(Parser parser) {
        for (Configuration dep : this.allDependencies()) {
            dep.configureParser(parser);
        }
    }

    public final void setupEncoder(Encoder encoder) {
        for (Configuration dep : this.allDependencies()) {
            dep.configureEncoder(encoder);
        }
    }

    protected void registerBindings(MutablePicoContainer container) {
    }

    protected void registerBindings(Map bindings) {
    }

    protected void configureBindings(MutablePicoContainer container) {
    }

    protected void configureBindings(Map bindings) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MutablePicoContainer setupContext(MutablePicoContainer container) {
        List dependencies = this.allDependencies();
        for (Configuration dependency : dependencies) {
            XSDSchemaLocator locator;
            XSDSchemaLocationResolver resolver = dependency.getSchemaLocationResolver();
            if (resolver != null) {
                QName key = new QName(dependency.getNamespaceURI(), "schemaLocationResolver");
                container.registerComponentInstance((Object)key, (Object)resolver);
            }
            if ((locator = dependency.getSchemaLocator()) != null) {
                QName key = new QName(dependency.getNamespaceURI(), "schemaLocator");
                container.registerComponentInstance((Object)key, (Object)locator);
            }
            Set set = dependency.getProperties();
            synchronized (set) {
                for (QName property : dependency.getProperties()) {
                    try {
                        container.registerComponentInstance((Object)property, (Object)property);
                    }
                    catch (DuplicateComponentKeyRegistrationException e) {}
                }
            }
            container = container.makeChildContainer();
            dependency.configureContext(container);
        }
        if (!this.context.getComponentAdapters().isEmpty()) {
            container = container.makeChildContainer();
            for (ComponentAdapter adapter : this.context.getComponentAdapters()) {
                container.registerComponent(adapter);
            }
        }
        return container;
    }

    protected void configureContext(MutablePicoContainer container) {
    }

    protected void configureParser(Parser parser) {
    }

    protected void configureEncoder(Encoder encoder) {
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Configuration) {
            Configuration other = (Configuration)obj;
            return Utilities.equals((Object)this.getNamespaceURI(), (Object)other.getNamespaceURI());
        }
        return false;
    }

    public final int hashCode() {
        if (this.getNamespaceURI() != null) {
            return this.getNamespaceURI().hashCode();
        }
        return 0;
    }

    static class DepEdge {
        DepNode src;
        DepNode dst;

        DepEdge(DepNode src, DepNode dst) {
            this.src = src;
            this.dst = dst;
        }

        public String toString() {
            return "[" + this.src.toString() + ", " + this.dst.toString() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DepNode {
        Configuration config;
        List<DepEdge> edges = new ArrayList<DepEdge>();

        DepNode(Configuration config) {
            this.config = config;
        }

        DepEdge getEdge(DepNode node) {
            for (DepEdge edge : this.edges) {
                if (edge.src != this || edge.dst != node) continue;
                return edge;
            }
            return null;
        }

        public List<DepNode> incoming() {
            ArrayList<DepNode> incoming = new ArrayList<DepNode>();
            for (DepEdge edge : this.edges) {
                if (edge.dst != this) continue;
                incoming.add(edge.src);
            }
            return incoming;
        }

        public List<DepNode> outgoing() {
            ArrayList<DepNode> outgoing = new ArrayList<DepNode>();
            for (DepEdge edge : this.edges) {
                if (edge.src != this) continue;
                outgoing.add(edge.dst);
            }
            return outgoing;
        }

        public String toString() {
            return this.config.toString();
        }
    }

    static class DepGraph {
        Map<Configuration, DepNode> nodes = new HashMap<Configuration, DepNode>();

        DepGraph() {
        }

        public void addEdge(Configuration from, Configuration to) {
            DepNode dst;
            DepNode src = this.addNode(from);
            DepEdge dep = src.getEdge(dst = this.addNode(to));
            if (dep != null) {
                return;
            }
            if (dst.getEdge(src) != null) {
                throw new IllegalArgumentException("Cycle between " + from + ", " + to);
            }
            dep = new DepEdge(src, dst);
            src.edges.add(dep);
            dst.edges.add(dep);
        }

        public void removeEdge(Configuration from, Configuration to) {
            DepNode dst;
            DepNode src = this.addNode(from);
            DepEdge dep = src.getEdge(dst = this.addNode(to));
            if (dep == null) {
                throw new IllegalStateException("No such edge: " + from + "," + to);
            }
            src.edges.remove(dep);
            dst.edges.remove(dep);
        }

        DepNode addNode(Configuration config) {
            DepNode node = this.nodes.get(config);
            if (node == null) {
                node = new DepNode(config);
                this.nodes.put(config, node);
            }
            return node;
        }
    }
}

