/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;

public class WCSClient {
    public static String wpsLocation = String.valueOf(System.getProperty("catalina.base")) + "/webapps/wps/";
    private static Logger LOGGER = Logger.getLogger(WCSClient.class);

    public static void main(String[] args) throws IOException {
        String endpoint = "http://localhost:8080/thredds/wcs/testALL/SST_MED_SST_L4_NRT_OBSERVATIONS_010_004_c_2011-11-03_2011-11-04.nc";
        String requestParameters = "service=WCS&version=1.0.0&request=GetCoverage&COVERAGE=analysed_sst&bbox=-18,20,36,45&width=100&height=100&format=geotiff";
        WCSClient.GetCoverage(new URL(String.valueOf(endpoint) + "?" + requestParameters));
        System.out.print("done");
    }

    public static GridCoverage2D GetCoverage(URL url) throws IllegalArgumentException, IOException {
        try {
            LOGGER.info((Object)("Getting coverage from : " + url));
            URLConnection uc = url.openConnection();
            if (uc == null) {
                throw new RuntimeException("Connection failed");
            }
            String contentType = uc.getContentType();
            if (contentType == null) {
                throw new RuntimeException("Content type is null or the file doesn't exists");
            }
            int contentLength = uc.getContentLength();
            if (contentLength == 0) {
                throw new RuntimeException("Content length is 0");
            }
            if (contentType.startsWith("text/") || contentLength == -1) {
                throw new IOException("This is not a binary file.");
            }
            InputStream raw = uc.getInputStream();
            BufferedInputStream in = new BufferedInputStream(raw);
            byte[] data = new byte[contentLength];
            int bytesRead = 0;
            int offset = 0;
            while (offset < contentLength) {
                bytesRead = ((InputStream)in).read(data, offset, data.length - offset);
                if (bytesRead == -1) break;
                offset += bytesRead;
            }
            ((InputStream)in).close();
            if (offset != contentLength) {
                throw new IOException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
            }
            File outDir = new File(wpsLocation, "/store/tmp/");
            outDir.mkdirs();
            File outFile = new File(wpsLocation, "/store/tmp/file.tif");
            FileOutputStream out = new FileOutputStream(outFile);
            out.write(data);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        File res = new File(wpsLocation, "/store/tmp/file.tif");
        if (res != null && res.length() > 0L) {
            GeoTiffFormat GTF = new GeoTiffFormat();
            GeoTiffReader GTR = GTF.getReader((Object)res);
            GridCoverage2D coverage = GTR.read(null);
            return coverage;
        }
        throw new IllegalStateException("File tif not downloaded");
    }
}

