/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.directoryOperation;

import com.mongodb.MongoException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryEntity;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryBucket {
    final Logger logger = LoggerFactory.getLogger(DirectoryBucket.class);
    public String file_separator = "/";
    String author;
    String fileName;
    String path;
    String[] server;

    public DirectoryBucket(String[] server, String path, String author) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DirectoryBucket PATH: " + path);
        }
        this.path = path;
        this.author = author;
        this.server = server;
    }

    public String generateBucket(DirectoryEntity dirObj, String rootArea) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("generateBucket() - start");
        }
        String[] bucketList = null;
        bucketList = this.retrieveBucketsName(this.path, rootArea);
        TransportManagerFactory tmf = new TransportManagerFactory(this.server);
        TransportManager tm = tmf.getTransport("mongo");
        for (int i = 0; i < bucketList.length; ++i) {
            if (i < bucketList.length - 1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(i + "creo bucket: " + bucketList[i] + " con chiave: " + bucketList[i + 1] + " e valore " + bucketList[i + 1]);
                }
                try {
                    tm.put(new DirectoryEntity(bucketList[i + 1], this.author), bucketList[i], bucketList[i + 1], true);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (MongoException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(i + "creo bucket: " + bucketList[i] + " con chiave: " + this.fileName + " e valore " + this.fileName);
            }
            if (dirObj != null) {
                dirObj.setDirectory(this.fileName);
                dirObj.setAuthor(this.author);
                try {
                    tm.put(dirObj, bucketList[i], this.fileName, true);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (MongoException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                tm.put(new DirectoryEntity(this.fileName, this.author), bucketList[i], this.fileName, true);
                continue;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                continue;
            }
            catch (MongoException e) {
                e.printStackTrace();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("generateBucket() - end");
        }
        return this.fileName;
    }

    public String[] retrieveBucketsName(String path, String rootArea) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("retrieveBucketsName() - start");
        }
        String pathCoded = new BucketCoding().mergingPathAndDir(rootArea, path);
        String[] splits = pathCoded.split(this.file_separator);
        String[] buckets = new String[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("splits[" + i + "] = " + splits[i]);
            }
            if (i > 0) {
                if (i == splits.length - 1) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("splits[" + i + "]= " + splits[i]);
                    }
                    this.fileName = buckets[i - 1] + splits[i];
                    buckets[i] = buckets[i - 1] + splits[i];
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("fileName: " + this.fileName);
                    break;
                }
                buckets[i] = buckets[i - 1] + splits[i] + "_-_";
            } else {
                buckets[i] = "_-_";
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("buckets[" + i + "]= " + buckets[i]);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("retrieveBucketsName() - end");
        }
        return buckets;
    }

    public void removeKeysOnDirBucket(String bucket, String rootArea) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("CHECK REMOVE: " + bucket);
        }
        String[] bucketList = null;
        bucketList = this.retrieveBucketsName(this.path, rootArea);
        TransportManagerFactory tmf = new TransportManagerFactory(this.server);
        TransportManager tm = tmf.getTransport("mongo");
        for (int i = 0; i < bucketList.length; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("REMOVE: check " + bucketList[i]);
            }
            if (!bucketList[i].equalsIgnoreCase(bucket)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removing key file: " + bucketList[i] + " from dir: " + bucketList[i - 1]);
            }
            Map map = null;
            try {
                map = tm.getValues(bucketList[i - 1], DirectoryEntity.class);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            catch (MongoException e) {
                e.printStackTrace();
            }
            Set set = map.keySet();
            tm.removeKey(bucketList[i - 1], bucketList[i]);
        }
    }

    public String removeDirBucket(String bucket, String rootArea) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("CHECK REMOVE: " + bucket);
        }
        String[] bucketList = null;
        BucketCoding bc = new BucketCoding();
        String bucketDirCoded = bc.bucketDirCoding(this.author, bucket, rootArea);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("bucketDir Coded: " + bucketDirCoded);
        }
        bucketList = this.retrieveBucketsName(bucket, rootArea);
        TransportManagerFactory tmf = new TransportManagerFactory(this.server);
        TransportManager tm = tmf.getTransport("mongo");
        for (int i = 0; i < bucketList.length; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("REMOVE: check " + bucketList[i] + " bucketDirCoded: " + bucketDirCoded);
            }
            if (!bucketDirCoded.contains(bucketList[i])) continue;
            Map map = null;
            try {
                map = tm.getValues(bucketList[i], DirectoryEntity.class);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            catch (MongoException e) {
                e.printStackTrace();
            }
            Set keys = map.keySet();
            for (String key : keys) {
                if (!key.equalsIgnoreCase(bucketDirCoded)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("key matched: " + key + " remove");
                }
                try {
                    map = tm.getValues(key, DirectoryEntity.class);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (MongoException e) {
                    e.printStackTrace();
                }
                keys = map.keySet();
                for (String key2 : keys) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("the bucket: " + key + " have a son: " + key2);
                    }
                    if (bc.isFileObject(key2)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("remove " + key2 + " in the bucket: " + key);
                        }
                        tm.removeKey(key, key2);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("remove all keys in the bucket: " + key2);
                        }
                        try {
                            tm.clearBucket(key2);
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                        }
                        catch (MongoException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(key2 + " is a directory");
                    }
                    String bucketDecoded = bc.bucketDirDecoding(key2, rootArea);
                    this.removeDirBucket(bucketDecoded, rootArea);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("remove " + key + " in the bucket: " + bucketList[i]);
                }
                tm.removeKey(bucketList[i], key);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("remove all keys in the bucket: " + key);
                }
                try {
                    tm.clearBucket(key);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (MongoException e) {
                    e.printStackTrace();
                }
            }
        }
        return bucketDirCoded;
    }

    public String searchInBucket(String name, String bucketCoded, TransportManager tm, String rootArea) {
        Map dirs = null;
        try {
            dirs = tm.getValues(bucketCoded, DirectoryEntity.class);
        }
        catch (Exception e) {
            this.logger.info("object not found");
            return null;
        }
        Set set = dirs.keySet();
        for (String key : set) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("try in " + key);
            }
            String nameDecoded = new BucketCoding().bucketFileDecoding(key, rootArea);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("name decoded: " + nameDecoded + " name searched is: " + name);
            }
            if (nameDecoded != null && nameDecoded.equalsIgnoreCase(name)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("FOUND in " + bucketCoded + " objectId returned: " + key);
                }
                return key;
            }
            this.searchInBucket(name, key, tm, rootArea);
        }
        return null;
    }
}

