/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import com.mongodb.MongoException;
import java.net.UnknownHostException;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSize
extends Operation {
    final Logger logger = LoggerFactory.getLogger(GetSize.class);
    public String file_separator = "/";

    public GetSize(String[] server, String bucket, Monitor monitor, boolean isChunk) {
        super(server, bucket, monitor, isChunk);
    }

    @Override
    public String doIt(MyFile myFile) {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server);
        TransportManager tm = tmf.getTransport("mongo");
        long dim = 0L;
        try {
            dim = tm.getSize(this.bucket);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" REMOVE " + this.bucket);
        }
        return "" + dim;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String[] dirs = remotePath.split(this.file_separator);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remotePath: " + remotePath);
        }
        String buck = null;
        BucketCoding bc = new BucketCoding();
        buck = bc.mergingPathAndFile(rootArea, remotePath);
        if (!"mongo".equalsIgnoreCase("mongo")) {
            buck = buck.replaceAll(this.file_separator, "_-_");
            DirectoryBucket dirBuc = new DirectoryBucket(server, remotePath, author);
            dirBuc.removeKeysOnDirBucket(buck, rootArea);
            Object bucketName = null;
        }
        this.bucket = buck;
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        throw new IllegalArgumentException("Input/Output stream is not compatible with getSize operation");
    }
}

