/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.DownloadAndLock;
import org.gcube.contentmanagement.blobstorage.service.operation.GetSize;
import org.gcube.contentmanagement.blobstorage.service.operation.GetTTL;
import org.gcube.contentmanagement.blobstorage.service.operation.GetUrl;
import org.gcube.contentmanagement.blobstorage.service.operation.Lock;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.service.operation.Remove;
import org.gcube.contentmanagement.blobstorage.service.operation.RenewTTL;
import org.gcube.contentmanagement.blobstorage.service.operation.Unlock;
import org.gcube.contentmanagement.blobstorage.service.operation.Upload;
import org.gcube.contentmanagement.blobstorage.service.operation.UploadAndUnlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationFactory {
    final Logger logger = LoggerFactory.getLogger(OperationFactory.class);
    String[] server;
    String bucket;
    Monitor monitor;
    boolean isChunk;

    public OperationFactory(String[] server, String bucket, Monitor monitor2, boolean isChunk) {
        this.server = server;
        this.bucket = bucket;
        this.monitor = monitor2;
        this.isChunk = isChunk;
    }

    public Operation getOperation(String operation) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("getOperation(String) - start " + operation);
        }
        Operation op = null;
        if (operation.equalsIgnoreCase("upload")) {
            op = new Upload(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("download")) {
            op = new Download(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("remove")) {
            op = new Remove(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("getSize")) {
            op = new GetSize(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("download+lock")) {
            op = new DownloadAndLock(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("upload+unlock")) {
            op = new UploadAndUnlock(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("lock")) {
            op = new Lock(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("unlock")) {
            op = new Unlock(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("getTTL")) {
            op = new GetTTL(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("renewTTL")) {
            op = new RenewTTL(this.server, this.bucket, this.monitor, this.isChunk);
        } else if (operation.equalsIgnoreCase("getUrl")) {
            op = new GetUrl(this.server, this.bucket, this.monitor, this.isChunk);
        } else {
            this.logger.error("getOperation(String) - Invalid Operation");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getOperation(String) - end");
        }
        return op;
    }
}

