/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.service.operation.OperationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationManager {
    final Logger logger = LoggerFactory.getLogger(OperationManager.class);
    private String[] server;
    private int dimension;
    private String operation;
    private MyFile resource;
    private boolean isChunk;
    private String bucketName;
    private String fileDest;
    private boolean isBase64;
    private String keyUnlock;
    public static final String CLIENT_TYPE = "mongo";
    public static final int MIN_THREAD = 1;
    public static final int MAX_THREAD = 10;
    public static final int sogliaNumeroMassimo = 400;
    public static final int sogliaNumeroMinimo = 4;
    public static final int sogliaDimensioneMinima = 0x100000;
    public static final int sogliaDimensioneMassima = 0x400000;

    public OperationManager(String[] server, int dim, String operation, MyFile myFile, boolean isChunk, String bucketName, boolean isBase64) {
        this.setServer(server);
        this.setTypeOperation(operation);
        this.setResource(myFile);
        this.setChunk(isChunk);
        this.setBase64(isBase64);
        this.setBucketName(bucketName);
        this.setTypeOperation(operation);
    }

    public OperationManager(String[] server, String operation, MyFile myFile) {
        this.setServer(server);
        this.setTypeOperation(operation);
        this.setResource(myFile);
        this.setTypeOperation(operation);
    }

    public OperationManager(String[] server, String operation, MyFile myFile, String keyUnlock) {
        this.keyUnlock = keyUnlock;
        this.setServer(server);
        this.setTypeOperation(operation);
        this.setResource(myFile);
        this.setTypeOperation(operation);
    }

    public Object startOperation(MyFile file, String remotePath, String author, String[] server, boolean chunkOpt, String rootArea, boolean replaceOption) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connection(boolean) - start");
        }
        this.logger.info("startOpertion getResource..getGcubeAccessType()= " + this.getResource().getGcubeAccessType() + " file..getGcubeAccessType() " + file.getGcubeAccessType());
        Monitor monitor = new Monitor();
        OperationFactory of = new OperationFactory(this.getServer(), this.getBucketName(), monitor, chunkOpt);
        Operation op = of.getOperation(this.getTypeOperation());
        this.setBucketName(op.initOperation(file, remotePath, author, server, rootArea, replaceOption));
        Object object = op.doIt(this.getResource());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connection(boolean) - end");
        }
        return object;
    }

    public Object startOperation(MyFile resource, String remotePath, String author, String[] server, boolean chunkOpt, String rootArea) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connection(boolean) - start");
        }
        Monitor monitor = new Monitor();
        OperationFactory of = new OperationFactory(this.getServer(), this.getBucketName(), monitor, chunkOpt);
        Operation op = of.getOperation(this.getTypeOperation());
        this.setBucketName(op.initOperation(resource, remotePath, author, server, rootArea));
        Object objectId = op.doIt(this.getResource());
        Object returnString = this.getBucketName();
        if (this.getTypeOperation().equalsIgnoreCase("upload")) {
            returnString = objectId;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connection(boolean) - end");
        }
        return returnString;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getFileDest() {
        return this.fileDest;
    }

    public void setFileDest(String fileDest) {
        this.fileDest = fileDest;
    }

    public boolean isChunk() {
        return this.isChunk;
    }

    public void setChunk(boolean isChunk) {
        this.isChunk = isChunk;
    }

    public String[] getServer() {
        return this.server;
    }

    public void setServer(String[] server) {
        this.server = server;
    }

    public String getTypeOperation() {
        return this.operation;
    }

    public void setTypeOperation(String operation) {
        this.operation = operation;
    }

    public MyFile getResource() {
        return this.resource;
    }

    public void setResource(MyFile resource) {
        this.resource = resource;
    }

    public boolean isBase64() {
        return this.isBase64;
    }

    public void setBase64(boolean isBase64) {
        this.isBase64 = isBase64;
    }
}

