/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.resources;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.node.Description;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.ServiceMap;

public abstract class GCUBEHostingNode
extends GCUBEResource {
    public static final String TYPE = "GHN";
    private static final String VERSION = "1.3.0";
    public static final String MAP_PREFIX = "ServiceMap_";
    private String infrastructure;
    private List<Package> packages = new ArrayList<Package>();
    private Site site;
    private Description nodeDescription;

    public GCUBEHostingNode() {
        this.type = TYPE;
        this.logger.setPrefix(TYPE);
    }

    public Description getNodeDescription() {
        return this.nodeDescription;
    }

    public void setNodeDescription(Description description) {
        this.nodeDescription = description;
    }

    public String getInfrastructure() {
        return this.infrastructure;
    }

    public void setInfrastructure(String description) {
        this.infrastructure = description;
    }

    public List<Package> getDeployedPackages() {
        return this.packages;
    }

    public Site getSite() {
        return this.site;
    }

    public void setSite(Site site) {
        this.site = site;
    }

    @Override
    public String getLastResourceVersion() {
        return VERSION;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GCUBEHostingNode other = (GCUBEHostingNode)obj;
        if (this.nodeDescription == null ? other.nodeDescription != null : !this.nodeDescription.equals(other.nodeDescription)) {
            return false;
        }
        if (this.infrastructure == null ? other.infrastructure != null : !this.infrastructure.equals(other.infrastructure)) {
            return false;
        }
        if (this.packages == null ? other.packages != null : !((Object)this.packages).equals(other.packages)) {
            return false;
        }
        return !(this.site == null ? other.site != null : !this.site.equals(other.site));
    }

    @Override
    public synchronized Set<GCUBEScope> validateAddScopes(GCUBEScope ... scopes) {
        Set<GCUBEScope> validScopes = super.validateAddScopes(scopes);
        GCUBEScope infrastructure = null;
        if (this.getScopes().size() == 0) {
            infrastructure = scopes[0].getInfrastructure();
            validScopes.add(infrastructure);
        } else {
            infrastructure = this.getScopes().values().iterator().next().getInfrastructure();
        }
        for (GCUBEScope scope : scopes) {
            if (scope.getInfrastructure().equals(infrastructure)) {
                switch (scope.getType()) {
                    case VRE: {
                        validScopes.add(scope.getEnclosingScope());
                        validScopes.add(scope);
                    }
                    case VO: {
                        validScopes.add(scope);
                    }
                }
                continue;
            }
            this.logger.warn("Cannot add " + scope + " to " + this.getClass().getSimpleName() + "(" + this.getID() + ") because outside the scope of the current infrastructure");
        }
        if (GHNContext.getContext().getGHNID() != null && GHNContext.getContext().getGHNID().compareToIgnoreCase(this.getID()) != 0) {
            return validScopes;
        }
        HashSet toremoveScopes = new HashSet();
        for (GCUBEScope scope : validScopes) {
            File mapFile = null;
            try {
                ServiceMap map = new ServiceMap();
                this.logger.trace("Loading service map for scope " + scope.getName());
                mapFile = this.getMapFile(scope);
                map.load(new FileReader(mapFile));
                scope.setServiceMap(map);
            }
            catch (Exception e) {
                this.logger.warn("Cannot add " + scope + " to " + this.getClass().getSimpleName() + "(" + this.getID() + ") because did not find the service map file " + mapFile.getPath(), e);
                toremoveScopes.remove(scope);
            }
        }
        validScopes.removeAll(toremoveScopes);
        return validScopes;
    }

    public File getMapFile(GCUBEScope scope) {
        if (scope.getType() == GCUBEScope.Type.VRE) {
            return GHNContext.getContext().getFile(MAP_PREFIX + scope.getEnclosingScope().getName() + ".xml", new boolean[0]);
        }
        return GHNContext.getContext().getFile(MAP_PREFIX + scope.getName() + ".xml", new boolean[0]);
    }

    @Override
    public synchronized Set<GCUBEScope> validateRemoveScopes(GCUBEScope ... scopes) {
        HashSet<GCUBEScope> set = new HashSet<GCUBEScope>();
        for (GCUBEScope scope : scopes) {
            if (!scope.isInfrastructure()) {
                set.add(scope);
                continue;
            }
            this.logger.warn("Cannot remove " + this.getClass().getSimpleName() + "(" + this.getID() + ") from its infrastructure");
        }
        return set;
    }

    public static class Package {
        String packageName;
        String packageVersion;
        String serviceName;
        String serviceClass;
        String serviceVersion;

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageVersion() {
            return this.packageVersion;
        }

        public void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceClass() {
            return this.serviceClass;
        }

        public void setServiceClass(String serviceClass) {
            this.serviceClass = serviceClass;
        }

        public String getServiceVersion() {
            return this.serviceVersion;
        }

        public void setServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Package other = (Package)obj;
            if (this.serviceClass == null ? other.serviceClass != null : !this.serviceClass.equals(other.serviceClass)) {
                return false;
            }
            if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
                return false;
            }
            if (this.packageVersion == null ? other.packageVersion != null : !this.packageVersion.equals(other.packageVersion)) {
                return false;
            }
            if (this.serviceVersion == null ? other.serviceVersion != null : !this.serviceVersion.equals(other.serviceVersion)) {
                return false;
            }
            return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
        }
    }

    public static class Site {
        String location;
        String country;
        String latitude;
        String longitude;
        String domain;

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getLatitude() {
            return this.latitude;
        }

        public void setLatitude(String latitude) {
            this.latitude = latitude;
        }

        public String getLongitude() {
            return this.longitude;
        }

        public void setLongitude(String longitude) {
            this.longitude = longitude;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Site other = (Site)obj;
            if (this.latitude == null ? other.latitude != null : !this.latitude.equals(other.latitude)) {
                return false;
            }
            if (this.longitude == null ? other.longitude != null : !this.longitude.equals(other.longitude)) {
                return false;
            }
            if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
                return false;
            }
            if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
                return false;
            }
            return !(this.country == null ? other.country != null : !this.country.equals(other.country));
        }
    }
}

