/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.util.ProcessTree;

public abstract class TaskController
implements Configurable {
    private Configuration conf;
    public static final Log LOG = LogFactory.getLog(TaskController.class);
    protected static final String COMMAND_FILE = "taskjvm.sh";
    protected LocalDirAllocator allocator;
    protected TaskTracker.LocalStorage localStorage;
    public static final FsPermission TASK_LAUNCH_SCRIPT_PERMISSION = FsPermission.createImmutable((short)448);

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public String[] getLocalDirs() {
        return this.localStorage.getDirs();
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public abstract void setup(LocalDirAllocator var1, TaskTracker.LocalStorage var2) throws IOException;

    public abstract void initializeJob(String var1, String var2, Path var3, Path var4, TaskUmbilicalProtocol var5, InetSocketAddress var6) throws IOException, InterruptedException;

    public abstract int launchTask(String var1, String var2, String var3, List<String> var4, List<String> var5, File var6, String var7, String var8) throws IOException;

    public abstract void signalTask(String var1, int var2, ProcessTree.Signal var3) throws IOException;

    public abstract void deleteAsUser(String var1, String var2) throws IOException;

    public abstract void createLogDir(TaskAttemptID var1, boolean var2) throws IOException;

    public abstract void deleteLogAsUser(String var1, String var2) throws IOException;

    public abstract void truncateLogsAsUser(String var1, List<Task> var2) throws IOException;

    public String getRunAsUser(JobConf conf) {
        return System.getProperty("user.name");
    }

    protected static String writeCommand(String cmdLine, FileSystem fs, Path commandFile) throws IOException {
        String path = commandFile.makeQualified(fs).toUri().getPath();
        OutputStreamWriter w = null;
        LOG.info((Object)("Writing commands to " + path));
        try {
            File parent = new File(path).getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("Couldn't ensure directory for task script: " + parent);
            }
            w = new FileWriter(path);
            w.write(cmdLine);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Caught IOException while writing JVM command line to file. ", (Throwable)ioe);
            throw ioe;
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
        fs.setPermission(commandFile, TASK_LAUNCH_SCRIPT_PERMISSION);
        return path;
    }

    protected void logOutput(String output) {
        String shExecOutput = output;
        if (shExecOutput != null) {
            for (String str : shExecOutput.split("\n")) {
                LOG.info((Object)str);
            }
        }
    }

    static class DeletionContext
    extends CleanupQueue.PathDeletionContext {
        private TaskController controller;
        private boolean isLog;
        private String user;
        private String subDir;

        DeletionContext(TaskController controller, boolean isLog, String user, String subDir) {
            super(null, null);
            this.controller = controller;
            this.isLog = isLog;
            this.user = user;
            this.subDir = subDir;
        }

        @Override
        protected void deletePath() throws IOException {
            if (this.isLog) {
                this.controller.deleteLogAsUser(this.user, this.subDir);
            } else {
                this.controller.deleteAsUser(this.user, this.subDir);
            }
        }

        @Override
        public String toString() {
            return (this.isLog ? "log(" : "dir(") + this.user + "," + this.subDir + ")";
        }
    }
}

