/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

class AddJarFileToIndex
extends IndexRequest {
    IFile resource;

    public AddJarFileToIndex(IFile resource, IndexManager manager) {
        super(resource.getFullPath(), manager);
        this.resource = resource;
    }

    public AddJarFileToIndex(IPath jarPath, IndexManager manager) {
        super(jarPath, manager);
    }

    public boolean equals(Object o) {
        if (o instanceof AddJarFileToIndex) {
            if (this.resource != null) {
                return this.resource.equals((Object)((AddJarFileToIndex)o).resource);
            }
            if (this.containerPath != null) {
                return this.containerPath.equals((Object)((AddJarFileToIndex)o).containerPath);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.resource != null) {
            return this.resource.hashCode();
        }
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        try {
            ZipFile zip;
            ReadWriteMonitor monitor;
            block51: {
                block52: {
                    block50: {
                        block49: {
                            block48: {
                                block46: {
                                    block47: {
                                        Index index = this.manager.getIndexForUpdate(this.containerPath, false, false);
                                        if (index != null) {
                                            if (!JobManager.VERBOSE) return true;
                                            org.eclipse.jdt.internal.core.util.Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                                            return true;
                                        }
                                        index = this.manager.getIndexForUpdate(this.containerPath, true, true);
                                        if (index == null) {
                                            if (!JobManager.VERBOSE) return true;
                                            org.eclipse.jdt.internal.core.util.Util.verbose("-> index could not be created for " + this.containerPath);
                                            return true;
                                        }
                                        monitor = index.monitor;
                                        if (monitor == null) {
                                            if (!JobManager.VERBOSE) return true;
                                            org.eclipse.jdt.internal.core.util.Util.verbose("-> index for " + this.containerPath + " just got deleted");
                                            return true;
                                        }
                                        zip = null;
                                        try {
                                            int max;
                                            Path zipFilePath = null;
                                            monitor.enterWrite();
                                            if (this.resource != null) {
                                                IPath location = this.resource.getLocation();
                                                if (location == null) {
                                                    Object var17_9 = null;
                                                    if (zip == null) break block46;
                                                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                                                    }
                                                    break block47;
                                                }
                                                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + location);
                                                }
                                                zip = new ZipFile(location.toFile());
                                                zipFilePath = (Path)this.resource.getFullPath().makeRelative();
                                            } else {
                                                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                                                }
                                                zip = new ZipFile(this.containerPath.toFile());
                                                zipFilePath = (Path)this.containerPath;
                                            }
                                            if (this.isCancelled) {
                                                if (JobManager.VERBOSE) {
                                                    org.eclipse.jdt.internal.core.util.Util.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                                                }
                                                break block48;
                                            }
                                            if (JobManager.VERBOSE) {
                                                org.eclipse.jdt.internal.core.util.Util.verbose("-> indexing " + zip.getName());
                                            }
                                            long initialTime = System.currentTimeMillis();
                                            String[] paths = index.queryDocumentNames("");
                                            int n = max = paths == null ? 0 : paths.length;
                                            if (max != 0) {
                                                boolean needToReindex;
                                                String EXISTS = "OK";
                                                String DELETED = "DELETED";
                                                SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                                                int i = 0;
                                                while (true) {
                                                    if (i >= max) break;
                                                    indexedFileNames.put(paths[i], DELETED);
                                                    ++i;
                                                }
                                                Enumeration<? extends ZipEntry> e = zip.entries();
                                                while (true) {
                                                    if (!e.hasMoreElements()) {
                                                        boolean bl = needToReindex = indexedFileNames.elementSize != max;
                                                    }
                                                    ZipEntry ze = e.nextElement();
                                                    String zipEntryName = ze.getName();
                                                    if (!Util.isClassFileName(zipEntryName)) continue;
                                                    indexedFileNames.put(zipEntryName, EXISTS);
                                                }
                                                if (!needToReindex) {
                                                    Object[] valueTable = indexedFileNames.valueTable;
                                                    int i2 = 0;
                                                    int l = valueTable.length;
                                                    while (i2 < l) {
                                                        if (valueTable[i2] == DELETED) {
                                                            needToReindex = true;
                                                            break;
                                                        }
                                                        ++i2;
                                                    }
                                                    if (!needToReindex) {
                                                        if (JobManager.VERBOSE) {
                                                            org.eclipse.jdt.internal.core.util.Util.verbose("-> no indexing required (index is consistent with library) for " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                                                        }
                                                        this.manager.saveIndex(index);
                                                        break block49;
                                                    }
                                                }
                                            }
                                            SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
                                            index = this.manager.recreateIndex(this.containerPath);
                                            if (index == null) {
                                                this.manager.removeIndex(this.containerPath);
                                                break block50;
                                            }
                                            Enumeration<? extends ZipEntry> e = zip.entries();
                                            while (true) {
                                                if (!e.hasMoreElements()) {
                                                    this.manager.saveIndex(index);
                                                    if (JobManager.VERBOSE) {
                                                        org.eclipse.jdt.internal.core.util.Util.verbose("-> done indexing of " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                                                    }
                                                    break block51;
                                                }
                                                if (this.isCancelled) {
                                                    if (JobManager.VERBOSE) {
                                                        org.eclipse.jdt.internal.core.util.Util.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                                                    }
                                                    break block52;
                                                }
                                                ZipEntry ze = e.nextElement();
                                                if (!Util.isClassFileName(ze.getName())) continue;
                                                byte[] classFileBytes = Util.getZipEntryByteContent(ze, zip);
                                                JavaSearchDocument entryDocument = new JavaSearchDocument(ze, (IPath)zipFilePath, classFileBytes, participant);
                                                this.manager.indexDocument(entryDocument, participant, index, this.containerPath);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var17_14 = null;
                                            if (zip != null) {
                                                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                                                }
                                                zip.close();
                                            }
                                            monitor.exitWrite();
                                            throw throwable;
                                        }
                                    }
                                    zip.close();
                                }
                                monitor.exitWrite();
                                return false;
                            }
                            Object var17_10 = null;
                            if (zip != null) {
                                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                                }
                                zip.close();
                            }
                            monitor.exitWrite();
                            return false;
                        }
                        Object var17_11 = null;
                        if (zip != null) {
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                            }
                            zip.close();
                        }
                        monitor.exitWrite();
                        return true;
                    }
                    Object var17_12 = null;
                    if (zip != null) {
                        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                            System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                        }
                        zip.close();
                    }
                    monitor.exitWrite();
                    return false;
                }
                Object var17_13 = null;
                if (zip != null) {
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                    }
                    zip.close();
                }
                monitor.exitWrite();
                return false;
            }
            Object var17_15 = null;
            if (zip != null) {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                }
                zip.close();
            }
            monitor.exitWrite();
            return true;
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }
}

