/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.ird.simpletestnono;

import com.terradue.wps_hadoop.common.StreamingAbstractAlgorithm;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class simpleTestNonoAlgorithm
extends StreamingAbstractAlgorithm<LongWritable, Text> {
    private static Logger LOGGER = Logger.getLogger(simpleTestNonoAlgorithm.class);
    public final String wpsLocation = System.getProperty("catalina.base") + "/webapps/wps";
    private List<String> errors = new ArrayList<String>();
    public UUID SessionUID;
    public String inputLocalTmpDirPath;
    public String inputHdfsTmpDirPath;

    public List<String> getErrors() {
        return this.errors;
    }

    public Class getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class getOutputDataType(String id) {
        return LiteralStringBinding.class;
    }

    @Override
    protected Map<String, IData> buildResults(Map<String, List<IData>> inputData) {
        String url_href = "";
        String final_url_href = "";
        try {
            List<IData> urls = inputData.get("urls");
            LOGGER.info((Object)("Deleting input path " + this.inputLocalTmpDirPath));
            FileUtils.deleteDirectory((File)new File(this.inputLocalTmpDirPath));
            int i = 0;
            File outputDir = new File(this.wpsLocation, "/store/outputs/");
            outputDir.mkdir();
            for (IData urlIData : urls) {
                this.hdfs.copyToLocalFile(new Path(this.hdfsPrefix + "/tmp/" + this.SessionUID + "_" + i), new Path(outputDir.getAbsolutePath()));
                outputDir = new File(outputDir, this.SessionUID + "_" + i);
                String hostname = WPSConfig.getInstance().getWPSConfig().getServer().getHostname();
                String port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
                url_href = "http://" + hostname + ":" + port + "/wps/store/outputs/" + this.SessionUID + "_" + i + "/" + outputDir.list(new PngFilenameFilter())[0];
                final_url_href = final_url_href + url_href + "\n";
                ++i;
            }
            File output = new File(this.wpsLocation, "/store/outputs/" + this.SessionUID);
            output.mkdirs();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        HashMap<String, IData> resulthash = new HashMap<String, IData>();
        resulthash.put("result", (IData)new LiteralStringBinding(final_url_href));
        return resulthash;
    }

    @Override
    protected String[] getArguments(Map<String, List<IData>> inputData) {
        if (inputData == null || !inputData.containsKey("urls")) {
            throw new RuntimeException("Error while allocating input parameters 'urls'");
        }
        List<IData> urls = inputData.get("urls");
        String urlsFilePath = "";
        LOGGER.info((Object)"Getting FileSystem from Configuration");
        try {
            this.hdfs = FileSystem.get((Configuration)this.hadoopConfig);
            this.hdfsPrefix = this.hdfs.getUri().toString();
            this.hdfsPrefix = this.hdfsPrefix + "/store";
            LOGGER.info((Object)("hdfsURI = " + this.hdfsPrefix));
            urlsFilePath = this.createUrlsFile(urls);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] arguments = new String[]{"-input", urlsFilePath, "-output", this.hdfsPrefix + "/tmp/outputs/" + this.SessionUID, "-mapper", this.wpsLocation + "/store/application/ird/simpleTestNono/run"};
        return arguments;
    }

    private String createUrlsFile(List<IData> urls) throws IOException, RuntimeException {
        this.SessionUID = UUID.randomUUID();
        LOGGER.info((Object)("SessionUID = " + this.SessionUID));
        String result = "";
        this.inputLocalTmpDirPath = this.wpsLocation + "/store/inputs/" + this.SessionUID;
        this.inputHdfsTmpDirPath = "/tmp/inputs/" + this.SessionUID;
        int i = 0;
        for (IData urlIData : urls) {
            LOGGER.info((Object)("Creating " + this.inputLocalTmpDirPath + "/files/urls/input.urls_" + i));
            String urlsPath = this.inputLocalTmpDirPath + "/files/urls/input.urls_" + i;
            new File(this.inputLocalTmpDirPath + "/files/urls/").mkdirs();
            File urlsf = new File(urlsPath);
            BufferedWriter buff = new BufferedWriter(new FileWriter(urlsf));
            String urlUID = this.SessionUID + "_" + i;
            LOGGER.info((Object)("urlUID = " + urlUID));
            ++i;
            LOGGER.info((Object)("Making dirs " + this.inputLocalTmpDirPath + "/files/" + urlUID));
            new File(this.inputLocalTmpDirPath + "/files/" + urlUID).mkdirs();
            LOGGER.info((Object)"Getting url input");
            String url = ((LiteralStringBinding)urlIData).getPayload();
            LOGGER.info((Object)"Writing into files.urls");
            buff.write(urlUID + ";" + url + ";");
            buff.close();
            LOGGER.info((Object)("Copying " + urlsPath + " to " + this.hdfsPrefix + this.inputHdfsTmpDirPath + "/urls/input.urls_" + i));
            this.hdfs.copyFromLocalFile(true, true, new Path(urlsPath), new Path(this.hdfsPrefix + this.inputHdfsTmpDirPath + "/urls/input.urls_" + i));
        }
        result = this.hdfsPrefix + this.inputHdfsTmpDirPath + "/urls/";
        return result;
    }

    private static final class PngFilenameFilter
    implements FilenameFilter {
        private static final Pattern IMAGE_FORMAT = Pattern.compile(".+\\.png", 2);

        private PngFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return IMAGE_FORMAT.matcher(name).matches();
        }
    }
}

