/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.streaming;

import com.terradue.wps_hadoop.streaming.PathResolver;
import org.apache.hadoop.conf.Configuration;
import org.n52.wps.commons.WPSConfig;

public class WpsHadoopConfiguration
extends Configuration {
    private static final String DEFAULT_BASE_URL = "sb-10-16-10-18.dev2.terradue.int";
    private static final String DEFAULT_HDFS_PORT = "8020";
    private static final String DEFAULT_MAPRED_PORT = "8021";
    private static final String HDFS_PREFIX = "hdfs://";
    private static final String DEFAULT_ALGORITHM_REPO_PATH = "/algorithmRepository/";
    private static final String DEFAULT_TMP_FOLDER_PATH = "/store/tmp/";
    private static final String DEFAULT_RUNNER_FILE_SH = "run";
    private static final String DEFAULT_INPUT_DATA_FILE_NAME = "inputData.txt";
    private static final String DEFAULT_HOST_NAME = WPSConfig.getInstance().getWPSConfig().getServer().getHostname();
    private static final String DEFAULT_PORT = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
    private static final String DEFAULT_WEB_APPLICATION_NAME = "wps";
    private static final String DEFAULT_WPS_LOCATION = System.getProperty("catalina.base") + "/webapps/wps";
    private String hdfsUrl = "hdfs://sb-10-16-10-18.dev2.terradue.int:8020";
    private String mapredUrl = "sb-10-16-10-18.dev2.terradue.int:8021";
    private String algorithmRepositoryPath = "hdfs:///algorithmRepository/";
    private PathResolver pathResolver;
    private String runnerFileSh = "run";
    private String tmpFolderPath = "/store/tmp/";
    private String inputDataFileName = "inputData.txt";
    private String webApplicationName = "wps";
    private String wpsLocation = DEFAULT_WPS_LOCATION;
    private String hostName = DEFAULT_HOST_NAME;
    private String port = DEFAULT_PORT;

    public WpsHadoopConfiguration() {
        super(true);
        this.updateHdfsUrl();
        this.updateMapredUrl();
        this.pathResolver = new PathResolver(){

            @Override
            public String getStreamingMapperPath(String algorithmName) {
                return algorithmName + ".jar/application/" + algorithmName + "/";
            }

            @Override
            public String getInputPath(String jobId) {
                return "/store/" + jobId + "/input/";
            }

            @Override
            public String getOutputPath(String jobId) {
                return "/store/" + jobId + "/output/";
            }

            @Override
            public String getOutputFilesPathStreaming(String jobId) {
                return WpsHadoopConfiguration.HDFS_PREFIX + this.getOutputPath(jobId) + "files/${mapred_task_id}/";
            }

            @Override
            public String getOutputFilesPath(String jobId) {
                return this.getOutputPath(jobId) + "files/";
            }

            @Override
            public String getAppPath(String algorithmName) {
                return "${job_local_dir}/../${mapred_task_id}/work/" + this.getStreamingMapperPath(algorithmName);
            }
        };
    }

    private void updateHdfsUrl() {
        this.set("fs.default.name", this.hdfsUrl);
    }

    private void updateMapredUrl() {
        this.set("mapred.job.tracker", this.mapredUrl);
    }

    public String getHdfsUrl() {
        return this.hdfsUrl;
    }

    public String getMapredUrl() {
        return this.mapredUrl;
    }

    public void setHdfsUrl(String hdfsUrl) {
        String hdfsPrefix = hdfsUrl.startsWith(HDFS_PREFIX) ? "" : HDFS_PREFIX;
        this.hdfsUrl = hdfsPrefix + hdfsUrl;
        this.updateHdfsUrl();
    }

    public void setHdfsUrl(String baseUrl, String port) {
        String hdfsPrefix = baseUrl.startsWith(HDFS_PREFIX) ? "" : HDFS_PREFIX;
        this.hdfsUrl = hdfsPrefix + baseUrl + ":" + port;
        this.updateHdfsUrl();
    }

    public void setMapredUrl(String mapredUrl) {
        this.mapredUrl = mapredUrl;
        this.updateMapredUrl();
    }

    public void setMapredUrl(String baseUrl, String port) {
        this.mapredUrl = baseUrl + ":" + port;
        this.updateMapredUrl();
    }

    public String getAlgorithmRepositoryPath() {
        return this.algorithmRepositoryPath;
    }

    public void setAlgorithmRepositoryPath(String algorithmRepositoryPath) {
        String hdfsPrefix = algorithmRepositoryPath.startsWith(HDFS_PREFIX) ? "" : HDFS_PREFIX;
        this.algorithmRepositoryPath = hdfsPrefix + algorithmRepositoryPath;
    }

    public PathResolver getPathResolver() {
        return this.pathResolver;
    }

    public void setPathResolver(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    public String getTmpFolderPath() {
        return this.tmpFolderPath;
    }

    public void setTmpFolderPath(String tmpFolderPath) {
        this.tmpFolderPath = tmpFolderPath;
    }

    public String getRunnerFileSh() {
        return this.runnerFileSh;
    }

    public void setRunnerFileSh(String runnerFileSh) {
        this.runnerFileSh = runnerFileSh;
    }

    public String getWpsLocation() {
        return this.wpsLocation;
    }

    public void setWpsLocation(String wpsLocation) {
        this.wpsLocation = wpsLocation;
    }

    public String getInputDataFileName() {
        return this.inputDataFileName;
    }

    public void setInputDataFileName(String inputDataFileName) {
        this.inputDataFileName = inputDataFileName;
    }

    public String getWebApplicationName() {
        return this.webApplicationName;
    }

    public void setWebApplicationName(String webApplicationName) {
        this.webApplicationName = webApplicationName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUrlBase() {
        return "http://" + this.hostName + (this.port == null || this.port == "" ? "" : ":" + this.port) + "/" + this.webApplicationName;
    }
}

