/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.util.EscapeStrings;

public class DAPNode
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    static DAPNode NULLNODE = new DAPNode("null", false);
    protected String _name;
    protected String _nameEncoded;
    private DAPNode _myParent = null;
    private boolean projected = false;
    private Attribute _attr;
    private AttributeTable _attrTbl;

    public DAPNode() {
        this(null);
    }

    public DAPNode(String n) {
        this(n, true);
    }

    public DAPNode(String n, boolean decodeName) {
        this._name = decodeName ? EscapeStrings.www2id(n) : n;
        this._nameEncoded = EscapeStrings.id2www(this._name);
    }

    public void setProjected(boolean tf) {
        this.projected = tf;
    }

    public boolean isProject() {
        return this.projected;
    }

    public void setProject(boolean state, boolean all) {
        this.setProjected(state);
    }

    public void setProject(boolean state) {
        this.setProject(state, true);
    }

    public void setParent(DAPNode bt) {
        this._myParent = bt;
    }

    public DAPNode getParent() {
        return this._myParent;
    }

    public final String getClearName() {
        return this._name;
    }

    public final String getName() {
        return this._nameEncoded;
    }

    public final void setName(String n) {
        this._nameEncoded = n;
        this.setClearName(EscapeStrings.www2id(n));
    }

    public void setClearName(String n) {
        this._name = n;
        this._nameEncoded = EscapeStrings.id2www(n);
        if (this._attr != null) {
            this._attr.setClearName(n);
        }
        if (this._attrTbl != null) {
            this._attrTbl.setClearName(n);
        }
    }

    public Object clone() {
        try {
            CloneMap map = new CloneMap();
            map.root = this;
            map.nodes.put(NULLNODE, NULLNODE);
            return this.cloneDAG(map);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static DAPNode cloneDAG(CloneMap map, DAPNode src) throws CloneNotSupportedException {
        DAPNode bt = map.nodes.get(src);
        if (bt == null) {
            bt = src.cloneDAG(map);
        }
        return bt;
    }

    public DAPNode cloneDAG(CloneMap map) throws CloneNotSupportedException {
        DAPNode node = (DAPNode)super.clone();
        map.nodes.put(this, node);
        if (this._myParent != null && this._myParent != map.root) {
            node._myParent = DAPNode.cloneDAG(map, this._myParent);
        }
        return node;
    }

    public static class CloneMap {
        Map<DAPNode, DAPNode> nodes = new HashMap<DAPNode, DAPNode>();
        DAPNode root = null;
    }
}

