/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.examples.tiff_uploader;

import com.terradue.wps_hadoop.common.HadoopAbstractAlgorithm;
import com.terradue.wps_hadoop.examples.tiff_uploader.TIFFUploaderMapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIFFUploaderAlgorithm
extends HadoopAbstractAlgorithm<LongWritable, Text> {
    private List<String> errors = new ArrayList<String>();
    public final UUID SessionUID = UUID.randomUUID();
    public final String wpsLocation = System.getProperty("catalina.base") + "/webapps/wps/";
    protected InetAddress addr;

    public List<String> getErrors() {
        return this.errors;
    }

    public Class getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class getOutputDataType(String id) {
        return LiteralStringBinding.class;
    }

    @Override
    public void prepareToRun(Map<String, List<IData>> inputData) {
        if (inputData == null || !inputData.containsKey("InputFile")) {
            throw new RuntimeException("Error while allocating input parameters InputFile");
        }
    }

    @Override
    protected Class<? extends Mapper<?, ?, LongWritable, Text>> getMapper() {
        return TIFFUploaderMapper.class;
    }

    @Override
    protected JobConf getJobConf() {
        JobConf conf = new JobConf(this.hadoopConfig);
        conf.set("restServerHost", "t2-10-11-30-97.play.terradue.int");
        conf.setInt("restServerPort", 8080);
        conf.setInt("requestTimeout", 120);
        conf.set("restBasePath", "geoserver");
        conf.set("restServerUsername", "admin");
        conf.set("restServerPassword", "geoserver");
        return conf;
    }

    @Override
    protected String getJobName() {
        return "tiffUploader";
    }

    @Override
    protected Path[] getInputPaths(Map<String, List<IData>> inputData) {
        String inputFile = ((LiteralStringBinding)inputData.get("InputFile").get(0)).getPayload();
        try {
            this.hdfs = FileSystem.get((Configuration)this.hadoopConfig);
            File inputD = new File(this.wpsLocation + "/store/IMarine/local/inputs/tiffUploader/" + this.SessionUID);
            inputD.mkdirs();
            File inputF = new File(inputD, "ncURLs");
            this.copyURLToFile(new URL(inputFile), inputF);
            this.hdfsPrefix = this.hdfs.getUri().toString();
            Path inputPath = new Path(this.hdfsPrefix + this.wpsLocation + "/store/IMarine/hdfs/inputs/tiffUploader/" + this.SessionUID + "/");
            this.hdfs.copyFromLocalFile(false, true, new Path(inputF.getPath()), inputPath);
            Path[] inputPaths = new Path[]{inputPath};
            return inputPaths;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void copyURLToFile(URL url, File f) {
        try {
            int count;
            URLConnection uc = url.openConnection();
            if (uc == null) {
                throw new RuntimeException("Connection failed");
            }
            String contentType = uc.getContentType();
            if (contentType == null) {
                throw new RuntimeException("Content type is null or the file doesn't exists");
            }
            int contentLength = uc.getContentLength();
            if (contentLength == 0) {
                throw new RuntimeException("Content length is 0");
            }
            BufferedInputStream in = null;
            FileOutputStream fout = null;
            in = new BufferedInputStream(url.openStream());
            fout = new FileOutputStream(f);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getOutputPath() {
        return this.wpsLocation + "/store/IMarine/hdfs/outputs/tiffUploader/" + this.SessionUID + "/";
    }

    @Override
    protected Map buildResults() {
        String result = "";
        String hostname = null;
        try {
            this.addr = InetAddress.getLocalHost();
            hostname = this.addr.getHostName();
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving host name " + e.getCause(), e);
        }
        JobConf job = this.getJobConf();
        result = "http://" + job.get("restServerHost") + ":" + job.getInt("restServerPort", 80) + "/" + job.get("restBasePath") + "/ows?service=wms&version=1.1.1&request=GetCapabilities";
        try {
            this.hdfs.copyToLocalFile(new Path(this.hdfsPrefix + this.getOutputPath()), new Path(this.wpsLocation + "/store/IMarine/local/outputs/" + this.SessionUID + "/"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, LiteralStringBinding> resulthash = new HashMap<String, LiteralStringBinding>();
        resulthash.put("result", new LiteralStringBinding(result));
        return resulthash;
    }
}

