/*
 * Decompiled with CFR 0.152.
 */
package opendap.util;

public class EscapeStrings {
    private static String _allowableInURI = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-+_/.\\*";
    private static String _allowableInURI_CE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-+_/.\\,";
    private static char _URIEscape = (char)37;

    public static String normalizeToXML(String s) {
        String xmlGT = "&gt;";
        String xmlLT = "&lt;";
        String xmlAmp = "&amp;";
        String xmlApos = "&apos;";
        String xmlQuote = "&quot;";
        StringBuffer sb = new StringBuffer(s);
        block7: for (int offset = 0; offset < sb.length(); ++offset) {
            char c = sb.charAt(offset);
            switch (c) {
                case '>': {
                    sb.replace(offset, offset + 1, xmlGT);
                    continue block7;
                }
                case '<': {
                    sb.replace(offset, offset + 1, xmlLT);
                    continue block7;
                }
                case '&': {
                    sb.replace(offset, offset + 1, xmlAmp);
                    continue block7;
                }
                case '\'': {
                    sb.replace(offset, offset + 1, xmlApos);
                    continue block7;
                }
                case '\"': {
                    sb.replace(offset, offset + 1, xmlQuote);
                    continue block7;
                }
            }
        }
        return sb.toString();
    }

    public static String id2www_ce(String in) {
        String s;
        try {
            s = EscapeStrings.escapeString(in, _allowableInURI_CE, _URIEscape);
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String escapeString(String in, String allowable, char esc) throws Exception {
        char[] inca;
        String out = "";
        if (in == null) {
            return null;
        }
        if (allowable.indexOf(esc) >= 0) {
            throw new Exception("Escape character MAY NOT be in the list of allowed characters!");
        }
        for (char candidate : inca = in.toCharArray()) {
            boolean isAllowed;
            boolean bl = isAllowed = allowable.indexOf(candidate) >= 0;
            if (isAllowed) {
                out = out + candidate;
                continue;
            }
            String c = Integer.toHexString(candidate);
            if (c.length() < 2) {
                c = "0" + c;
            }
            out = out + esc + c;
        }
        return out;
    }

    public static String id2www(String in) {
        String s;
        try {
            s = EscapeStrings.escapeString(in, _allowableInURI, _URIEscape);
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String unescapeString(String in, char escape, String except) {
        if (in == null) {
            return null;
        }
        String esc = String.valueOf(escape);
        String out = in;
        int i = 0;
        while ((i = out.indexOf(esc, i)) != -1) {
            String candidate = out.substring(i, i + 3);
            if (candidate.equals(except)) {
                i += 3;
                continue;
            }
            String replacement = Character.toString((char)Integer.valueOf(out.substring(i + 1, i + 3), 16).intValue());
            out = out.substring(0, i) + replacement + out.substring(i + 3, out.length());
            if (!replacement.equals(esc)) continue;
            ++i;
        }
        return out;
    }

    public static String www2id(String in) {
        return EscapeStrings.unescapeString(in, _URIEscape, "");
    }

    public static String www2ce(String in) {
        return EscapeStrings.unescapeString(in, _URIEscape, "%20");
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            for (String s : args) {
                System.out.println("id2www - Input: \"" + s + "\"   Output: \"" + EscapeStrings.id2www(s) + "\"   recaptured: " + EscapeStrings.www2id(EscapeStrings.id2www(s)));
            }
            for (String s : args) {
                String out = EscapeStrings.id2www(s);
                System.out.println("www2id - Input: \"" + out + "\"   Output: \"" + EscapeStrings.www2id(out) + "\" recaptured: " + EscapeStrings.id2www(EscapeStrings.www2id(out)));
            }
        } else {
            char[] allBytes = new char[256];
            for (int b = 0; b < 256; ++b) {
                allBytes[b] = (char)b;
            }
            String allChars = new String(allBytes);
            System.out.println("id2www All Characters");
            System.out.println("Input String:      \"" + allChars + "\"");
            System.out.println("Output String:     \"" + EscapeStrings.id2www(allChars) + "\"");
            System.out.println("Recaptured String: \"" + EscapeStrings.www2id(EscapeStrings.id2www(allChars)) + "\" ");
        }
    }
}

