/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.examples.bathymetry;

import com.terradue.wps_hadoop.common.HadoopAbstractAlgorithm;
import com.terradue.wps_hadoop.processes.examples.bathymetry.BathymetryMapper;
import com.terradue.wps_hadoop.processes.examples.bathymetry.BathymetryReducer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class BathymetryAlgorithm
extends HadoopAbstractAlgorithm<LongWritable, Text> {
    private List<String> errors = new ArrayList<String>();
    private String inputFile = "";
    public final UUID SessionUID = UUID.randomUUID();
    public final String wpsLocation = System.getProperty("catalina.base") + "/webapps/wps/";
    protected InetAddress addr;

    public List<String> getErrors() {
        return this.errors;
    }

    public Class getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class getOutputDataType(String id) {
        return LiteralStringBinding.class;
    }

    @Override
    public void prepareToRun(Map<String, List<IData>> inputData) {
        if (inputData == null || !inputData.containsKey("InputFile")) {
            throw new RuntimeException("Error while allocating input parameters InputFile");
        }
        if (inputData == null || !inputData.containsKey("coordinates")) {
            throw new RuntimeException("Error while allocating input parameters coordinates");
        }
        this.inputFile = ((LiteralStringBinding)inputData.get("InputFile").get(0)).getPayload();
        System.out.println("inputFile " + this.inputFile);
    }

    @Override
    protected Class<? extends Mapper<?, ?, LongWritable, Text>> getMapper() {
        return BathymetryMapper.class;
    }

    @Override
    protected Class<? extends Reducer<LongWritable, Text, ?, ?>> getReducer() {
        return BathymetryReducer.class;
    }

    @Override
    protected JobConf getJobConf() {
        JobConf conf = new JobConf(this.hadoopConfig);
        conf.set("inputFile", this.inputFile);
        return new JobConf(((Object)((Object)this)).getClass());
    }

    @Override
    protected String getJobName() {
        return "bathymetry";
    }

    @Override
    protected Path[] getInputPaths(Map<String, List<IData>> inputData) {
        String coordinates = ((LiteralStringBinding)inputData.get("coordinates").get(0)).getPayload();
        try {
            this.hdfs = FileSystem.get((Configuration)this.hadoopConfig);
            File coordinatesF = new File(this.wpsLocation + "/store/IMarine/local/inputs/" + this.SessionUID + "/coordinates");
            coordinatesF.getParentFile().mkdirs();
            System.out.println("coordinate file = " + coordinates);
            this.copyURLToFile(new URL(coordinates), coordinatesF);
            this.hdfsPrefix = this.hdfs.getUri().toString();
            Path coordPath = new Path(this.hdfsPrefix + this.wpsLocation + "/store/IMarine/hdfs/inputs/" + this.SessionUID + "/");
            this.hdfs.copyFromLocalFile(false, true, new Path(coordinatesF.getPath()), coordPath);
            Path[] inputPaths = new Path[]{coordPath};
            return inputPaths;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void copyURLToFile(URL url, File f) {
        try {
            int count;
            int contentLength;
            URLConnection uc = url.openConnection();
            if (uc == null) {
                throw new RuntimeException("Connection failed");
            }
            String contentType = uc.getContentType();
            if (contentType == null) {
                System.out.println("Content type is null or the file doesn't exists");
            }
            if ((contentLength = uc.getContentLength()) == 0) {
                throw new RuntimeException("Content length is 0");
            }
            BufferedInputStream in = null;
            FileOutputStream fout = null;
            in = new BufferedInputStream(url.openStream());
            fout = new FileOutputStream(f);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getOutputPath() {
        return this.wpsLocation + "/store/IMarine/hdfs/outputs/" + this.SessionUID + "/";
    }

    @Override
    protected Map buildResults() {
        this.update(new Integer(100));
        String result = "";
        String hostname = null;
        try {
            this.addr = InetAddress.getLocalHost();
            hostname = this.addr.getHostName();
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving host name " + e.getCause(), e);
        }
        result = "http://" + hostname + ":8888/wps/outputs/" + this.SessionUID.toString() + "/part-00000";
        try {
            this.hdfs.copyToLocalFile(new Path(this.hdfsPrefix + this.getOutputPath()), new Path(this.wpsLocation + "/store/IMarine/local/outputs/" + this.SessionUID + "/"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, LiteralStringBinding> resulthash = new HashMap<String, LiteralStringBinding>();
        resulthash.put("result", new LiteralStringBinding(result));
        return resulthash;
    }

    public List<String> getInputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("coordinates");
        return identifierList;
    }

    public List<String> getOutputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("result");
        return identifierList;
    }
}

