/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client;

import com.terradue.jcatalogue.client.Catalogue;
import com.terradue.jcatalogue.client.CatalogueEntity;
import com.terradue.jcatalogue.client.OpenSearchParameter;
import com.terradue.jcatalogue.client.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class OpenSearchUrl
extends CatalogueEntity {
    private static final String APPLICATION_ATOM_XML = "application/atom+xml";
    private static final String PARAM_DELIMITER = "&";
    private static final String OPTIONAL_MARKER = "?";
    private static final Pattern PARAM_VALUE_PATTERN = Pattern.compile("\\{(([\\w:_]+)(\\?)?)\\}");
    private final String type;
    private final String baseUrl;
    private final OpenSearchParameter[] parameters;

    public OpenSearchUrl(String type, String template) {
        this.type = type;
        int queryDelimiterIndex = template.indexOf(63);
        this.baseUrl = template.substring(0, queryDelimiterIndex);
        StringTokenizer parametersTokenizer = new StringTokenizer(template.substring(queryDelimiterIndex + 1), PARAM_DELIMITER);
        this.parameters = new OpenSearchParameter[parametersTokenizer.countTokens()];
        int index = 0;
        while (parametersTokenizer.hasMoreTokens()) {
            String parameter = parametersTokenizer.nextToken();
            int parameterSeparatorIndex = parameter.indexOf(61);
            String key = parameter.substring(0, parameterSeparatorIndex);
            String value = parameter.substring(parameterSeparatorIndex + 1);
            Matcher matcher = PARAM_VALUE_PATTERN.matcher(value);
            if (matcher.matches()) {
                boolean mandatory = 4 == matcher.groupCount() && OPTIONAL_MARKER.equals(matcher.group(3));
                this.parameters[index] = new OpenSearchParameter(key, matcher.group(2), mandatory);
            }
            ++index;
        }
    }

    public Catalogue invoke(Parameter ... parameters) {
        if (!APPLICATION_ATOM_XML.equals(this.type)) {
            throw new IllegalStateException("Direct URL invocation supports application/atom+xml only");
        }
        HashSet<String> parametersName = new HashSet<String>();
        for (Parameter parameter : parameters) {
            parametersName.add(parameter.getName());
        }
        for (OpenSearchParameter searchParameter : this.parameters) {
            if (!searchParameter.isMandatory() || parametersName.contains(searchParameter.getKey())) continue;
            throw new IllegalArgumentException(String.format("Mandatory parameter %s not found!", searchParameter.getKey()));
        }
        return this.getCatalogueClient().getCatalogue(this.baseUrl, parameters);
    }

    public String getType() {
        return this.type;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public OpenSearchParameter[] getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "OpenSearchUrl(type=" + this.getType() + ", baseUrl=" + this.getBaseUrl() + ", parameters=" + Arrays.deepToString(this.getParameters()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchUrl)) {
            return false;
        }
        OpenSearchUrl other = (OpenSearchUrl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType())) {
            return false;
        }
        if (this.getBaseUrl() == null ? other.getBaseUrl() != null : !this.getBaseUrl().equals(other.getBaseUrl())) {
            return false;
        }
        return Arrays.deepEquals(this.getParameters(), other.getParameters());
    }

    public boolean canEqual(Object other) {
        return other instanceof OpenSearchUrl;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + (this.getType() == null ? 0 : this.getType().hashCode());
        result = result * 31 + (this.getBaseUrl() == null ? 0 : this.getBaseUrl().hashCode());
        result = result * 31 + Arrays.deepHashCode(this.getParameters());
        return result;
    }
}

