/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.internal.converters;

import com.terradue.jcatalogue.client.geo.Line;
import com.terradue.jcatalogue.client.geo.Point;
import com.terradue.jcatalogue.client.geo.Polygon;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;

public final class GeoConverter
implements Converter {
    private static final String SEPARATOR = " ";
    private static final int EVEN_VERIFIER = 2;
    private final Converter doubleConverter = ConvertUtils.lookup(Double.class);

    public Object convert(Class type, Object value) {
        if (value == null) {
            throw new ConversionException("Null values not supported in this version.");
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.isEmpty()) {
                throw new ConversionException("empty value cannot be converted to a valid GeoLocation");
            }
            String[] values = stringValue.split(SEPARATOR);
            if (values.length % 2 != 0) {
                throw new ConversionException(String.format("Cannot convert %s to a Geo representation, coordinates must be even in number (%s)", value, values.length));
            }
            Point[] points = new Point[values.length / 2];
            for (int i = 0; i < values.length; i += 2) {
                Double latitude = (Double)this.doubleConverter.convert(Double.class, (Object)values[i]);
                Double longitude = (Double)this.doubleConverter.convert(Double.class, (Object)values[i + 1]);
                points[i / 2] = new Point(latitude, longitude);
            }
            if (Line.class == type) {
                return new Line(points);
            }
            if (Point.class == type) {
                return points[0];
            }
            if (Polygon.class == type) {
                if (!points[0].equals(points[points.length - 1])) {
                    throw new ConversionException("Input points don't descrive a valid Polygon, first and last Points are not equals");
                }
                return new Polygon(points);
            }
        }
        throw new ConversionException(String.format("type %s and value %s not supported", type, value));
    }
}

