/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralDateTimeBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class InputUtils {
    public static List<String> getListStringInputParameter(Map<String, List<IData>> inputData, String parameterName) {
        return InputUtils.getListStringInputParameter(inputData, parameterName, false);
    }

    public static List<String> getListStringInputParameter(Map<String, List<IData>> inputData, String parameterName, boolean almostOne) {
        List<IData> list = InputUtils.getIdataList(inputData, parameterName, almostOne);
        ArrayList<String> res = new ArrayList<String>();
        for (IData iData : list) {
            res.add(((LiteralStringBinding)iData).getPayload());
        }
        return res;
    }

    public static List<Integer> getListIntegerInputParameter(Map<String, List<IData>> inputData, String parameterName) {
        return InputUtils.getListIntegerInputParameter(inputData, parameterName, false);
    }

    public static List<Integer> getListIntegerInputParameter(Map<String, List<IData>> inputData, String parameterName, boolean almostOne) {
        List<IData> list = InputUtils.getIdataList(inputData, parameterName, almostOne);
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (IData iData : list) {
            res.add(((LiteralIntBinding)iData).getPayload());
        }
        return res;
    }

    private static List<IData> getIdataList(Map<String, List<IData>> inputData, String parameterName, boolean almostOne) {
        List<IData> list = inputData.get(parameterName);
        if (list == null || list.size() == 0) {
            if (almostOne) {
                throw new RuntimeException("Parameter \"" + parameterName + "\" must have almost one element.");
            }
            return new ArrayList<IData>();
        }
        return list;
    }

    public static String getStringInputParameter(Map<String, List<IData>> inputData, String parameterName, String defaultValue) {
        String ris = InputUtils.getStringInputParameter(inputData, parameterName, false);
        return ris == null ? defaultValue : ris;
    }

    public static String getStringInputParameter(Map<String, List<IData>> inputData, String parameterName) {
        return InputUtils.getStringInputParameter(inputData, parameterName, false);
    }

    public static String getStringInputParameter(Map<String, List<IData>> inputData, String parameterName, boolean mandatory) {
        List<IData> list = inputData.get(parameterName);
        if (list == null || list.size() == 0) {
            if (mandatory) {
                throw new RuntimeException("Parameter \"" + parameterName + "\" is mandatory.");
            }
            return null;
        }
        IData iData = list.get(0);
        return ((LiteralStringBinding)iData).getPayload();
    }

    public static Integer getIntegerInputParameter(Map<String, List<IData>> inputData, String parameterName) {
        return InputUtils.getIntegerInputParameter(inputData, parameterName, false);
    }

    public static Integer getIntegerInputParameter(Map<String, List<IData>> inputData, String parameterName, boolean mandatory) {
        List<IData> list = inputData.get(parameterName);
        if (list == null || list.size() == 0) {
            if (mandatory) {
                throw new RuntimeException("Parameter \"" + parameterName + "\" is mandatory.");
            }
            return null;
        }
        IData iData = list.get(0);
        return ((LiteralIntBinding)iData).getPayload();
    }

    public static Integer getIntegerInputParameter(Map<String, List<IData>> inputData, String parameterName, int defaultValue) {
        Integer ris = InputUtils.getIntegerInputParameter(inputData, parameterName, false);
        return ris == null ? defaultValue : ris;
    }

    public static String getDateTimeInputParameter(Map<String, List<IData>> inputData, String parameterName) {
        List<IData> list = inputData.get(parameterName);
        if (list == null || list.size() == 0) {
            return null;
        }
        IData iData = list.get(0);
        return ((LiteralDateTimeBinding)iData).getPayload().toString();
    }

    public static Boolean getBooleanInputParameter(Map<String, List<IData>> inputData, String parameterName) {
        return InputUtils.getBooleanInputParameter(inputData, parameterName, false);
    }

    public static Boolean getBooleanInputParameter(Map<String, List<IData>> inputData, String parameterName, boolean mandatory) {
        List<IData> list = inputData.get(parameterName);
        if (list == null || list.size() == 0) {
            if (mandatory) {
                throw new RuntimeException("Parameter \"" + parameterName + "\" is mandatory.");
            }
            return null;
        }
        IData iData = list.get(0);
        String value = ((LiteralStringBinding)iData).getPayload().toLowerCase();
        return value.contentEquals("true") || value.contentEquals("on") || value.contentEquals("1") || value.contentEquals("y") || value.contentEquals("t") || value.contentEquals("yes");
    }

    public static Boolean getBooleanInputParameter(Map<String, List<IData>> inputData, String parameterName, Boolean defaultValue) {
        Boolean ris = InputUtils.getBooleanInputParameter(inputData, parameterName, false);
        return ris == null ? defaultValue : ris;
    }
}

