/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import com.terradue.wps_hadoop.streaming.UpdateHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;

public class StreamJobMod
extends StreamJob {
    public static String test = "";
    private static final float MAP_PERCENT_WEIGHT = 60.0f;
    private static final float REDUCE_PERCENT_WEIGHT = 40.0f;

    public int run(String[] args, UpdateHandler updateHandler) throws Exception {
        try {
            this.argv_ = args;
            this.init();
            this.preProcessArgs();
            this.parseArgv();
            this.postProcessArgs();
            this.setJobConf();
            return this.submitAndMonitorJob(updateHandler);
        }
        catch (IllegalArgumentException ex) {
            LOG.debug((Object)"Error in streaming job", (Throwable)ex);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int submitAndMonitorJob(UpdateHandler updateHandler) throws IOException {
        int n;
        if (this.jar_ != null && this.isLocalHadoop()) {
            File wd = new File(".").getAbsoluteFile();
            StreamUtil.unJar((File)new File(this.jar_), (File)wd);
        }
        this.jc_ = new JobClient(this.jobConf_);
        boolean error = true;
        this.running_ = null;
        String lastReport = null;
        try {
            this.running_ = this.jc_.submitJob(this.jobConf_);
            this.jobId_ = this.running_.getID();
            LOG.info((Object)("getLocalDirs(): " + Arrays.asList(this.jobConf_.getLocalDirs())));
            LOG.info((Object)("(by wps-hadoop) JobId: " + this.jobId_));
            this.jobInfo();
            while (!this.running_.isComplete()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.running_ = this.jc_.getJob(this.jobId_);
                String report = null;
                int mapPercent = Math.round(this.running_.mapProgress() * 100.0f);
                int reducePercent = Math.round(this.running_.reduceProgress() * 100.0f);
                if (updateHandler != null) {
                    updateHandler.triggerUpdate("" + Math.round((float)mapPercent * 60.0f / 100.0f + (float)reducePercent * 40.0f / 100.0f));
                }
                if ((report = " map " + mapPercent + "%  reduce " + reducePercent + "%").equals(lastReport)) continue;
                LOG.info((Object)report);
                lastReport = report;
            }
            if (!this.running_.isSuccessful()) {
                this.jobInfo();
                LOG.error((Object)("Job not successful. Error: " + this.running_.getFailureInfo()));
                int report = 1;
                return report;
            }
            LOG.info((Object)("Job complete: " + this.jobId_));
            LOG.info((Object)("Output: " + this.output_));
            error = false;
        }
        catch (FileNotFoundException fe) {
            LOG.error((Object)("Error launching job , bad input path : " + fe.getMessage()));
            n = 2;
            return n;
        }
        catch (InvalidJobConfException je) {
            LOG.error((Object)("Error launching job , Invalid job conf : " + je.getMessage()));
            n = 3;
            return n;
        }
        catch (FileAlreadyExistsException fae) {
            LOG.error((Object)("Error launching job , Output path already exists : " + fae.getMessage()));
            n = 4;
            return n;
        }
        catch (IOException ioe) {
            LOG.error((Object)("Error Launching job : " + ioe.getMessage()));
            n = 5;
            return n;
        }
        finally {
            if (error && this.running_ != null) {
                LOG.info((Object)"killJob...");
                this.running_.killJob();
            }
            this.jc_.close();
        }
        return 0;
    }
}

