/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.fishfinder.tmplugin.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.security.Key;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.data.fishfinder.tmplugin.FishFinderPlugin;
import org.gcube.data.fishfinder.tmplugin.dbconnection.ConnectionPool;
import org.gcube.data.fishfinder.tmplugin.dbconnection.ConnectionPoolException;
import org.gcube.data.fishfinder.tmplugin.dbconnection.FishFinderTable;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger log = LoggerFactory.getLogger(Utils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SQLTableExists(String tableName) {
        boolean exists = false;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";
            results = statement.executeQuery(sqlText);
            exists = results.next();
        }
        catch (SQLException e) {
            log.error("SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            log.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                log.error("sql Error", (Throwable)ex);
            }
        }
        return exists;
    }

    public static String toSchema(Class<?> clazz) {
        final StringWriter writer = new StringWriter();
        SchemaOutputResolver resolver = new SchemaOutputResolver(){

            public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                StreamResult result = new StreamResult(writer);
                result.setSystemId("anything");
                return result;
            }
        };
        try {
            JAXBContext ctxt = JAXBContext.newInstance((Class[])new Class[]{clazz});
            ctxt.generateSchema(resolver);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static void getRuntimeResource() {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'DataSource' and $resource/Profile/Name eq 'Figis' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources.size() != 0) {
            try {
                Utils.initialize((ServiceEndpoint)resources.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void initialize(ServiceEndpoint res) throws Exception {
        try {
            log.trace("Retrieving Runtime Resource...");
            for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
                if (ap.name().equals("rest")) {
                    FishFinderPlugin.baseUrl = ap.address();
                    for (ServiceEndpoint.Property p : ap.properties()) {
                        if (p.name().equals("extractAllCsv")) {
                            FishFinderPlugin.extractAllCsv = p.value();
                            continue;
                        }
                        if (!p.name().equals("reinitialize")) continue;
                        FishFinderPlugin.reinitialize = p.value();
                    }
                }
                if (!ap.name().equals("jdbc")) continue;
                FishFinderPlugin.dbPassword = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                FishFinderPlugin.jdbc = ap.address();
                FishFinderPlugin.dbLogin = ap.username();
            }
        }
        catch (Exception e) {
            log.error("Error retrieving Runtime Resource");
        }
        log.trace("Retrieved Runtime Resource");
    }

    public static void createTableFigis() {
        try {
            if (!Utils.SQLTableExists("figis")) {
                FishFinderTable figis = new FishFinderTable();
                if (figis.create().booleanValue()) {
                    Utils.setlastupdate();
                    log.info("Table figis created with success!");
                } else {
                    log.error("Error creating table figis.");
                }
            } else {
                log.info("Table figis already exists, skip creation table.");
            }
        }
        catch (Exception e) {
            log.error("Error creating table figis ", (Throwable)e);
        }
    }

    public static void createTableUpdates() {
        try {
            if (!Utils.SQLTableExists("updates")) {
                FishFinderTable figis = new FishFinderTable();
                if (figis.createTabUpdates()) {
                    log.info("Table updates created with success!");
                } else {
                    log.error("Error creating table updates");
                }
            } else {
                log.info("Table updates already exists, skip creation table.");
            }
        }
        catch (Exception e) {
            log.error("Error creating table  updates", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setlastupdate() {
        log.trace("set last update date");
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            java.util.Date date = new java.util.Date();
            long dt = date.getTime();
            Date today = new Date(dt);
            String query = "insert into updates (date) values ('" + today + "')";
            boolean result = pool.insertPreStatement(query);
            if (!result) {
                log.info("problem setting last update date");
            }
        }
        catch (ConnectionPoolException e) {
            log.error("ConnectionPoolException", (Throwable)e);
        }
        catch (SQLException e) {
            log.error("SQLException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar lastupdate() {
        log.trace("get last update date");
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        Calendar lastUpdate = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            String query = "select date from updates where id= (select max(id) from updates)";
            results = statement.executeQuery(query);
            if (results.next()) {
                lastUpdate = Utils.DateToCalendar(results.getDate(1));
            }
        }
        catch (SQLException e) {
            log.error("SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            log.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                log.error("sql Error", (Throwable)ex);
            }
        }
        return lastUpdate;
    }

    public static Calendar DateToCalendar(java.util.Date date) {
        Calendar cal = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            date = formatter.parse(date.toString());
            cal = Calendar.getInstance();
            cal.setTime(date);
        }
        catch (ParseException e) {
            log.error("Exception", (Throwable)e);
        }
        return cal;
    }
}

