/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.fishfinder.tmplugin.repository;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.gcube.data.fishfinder.tmplugin.FishFinderPlugin;
import org.gcube.data.fishfinder.tmplugin.dbconnection.FishFinderTable;
import org.gcube.data.fishfinder.tmplugin.repository.Repository;
import org.gcube.data.fishfinder.tmplugin.repository.Summary;
import org.gcube.data.fishfinder.tmplugin.repository.iterators.FishFinderRecord;
import org.gcube.data.fishfinder.tmplugin.repository.iterators.RecordIterator;
import org.gcube.data.fishfinder.tmplugin.requests.Request;
import org.gcube.data.fishfinder.tmplugin.utils.FishFinderTreeGenerator;
import org.gcube.data.fishfinder.tmplugin.utils.Utils;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.exceptions.StreamException;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRepository
implements Repository {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BaseRepository.class);
    private transient String name;
    private transient String description;
    private FishFinderTreeGenerator binder;

    public BaseRepository(Request request) throws Exception {
        this.description = request.getDescription();
        this.name = request.getName();
        this.binder = new FishFinderTreeGenerator(request);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Tree get(String id) throws UnknownTreeException, Exception {
        log.trace("Get figis records by ID {}", (Object)id);
        FishFinderRecord record = null;
        try {
            FishFinderTable figisTable = new FishFinderTable();
            record = figisTable.getRecordByID(id);
            return this.binder.bind(record);
        }
        catch (Exception e) {
            throw new UnknownTreeException(id, (Throwable)e);
        }
    }

    @Override
    public Stream<Tree> getRecords() throws UnknownTreeException, Exception {
        log.trace("Get all figis records");
        RecordIterator records = new RecordIterator();
        Generator<FishFinderRecord, Tree> parser = new Generator<FishFinderRecord, Tree>(){

            public Tree yield(FishFinderRecord record) {
                try {
                    return BaseRepository.this.binder.bind(record);
                }
                catch (Exception e) {
                    throw new StreamException();
                }
            }
        };
        return Streams.pipe((Stream)records).through((Generator)parser);
    }

    @Override
    public Summary summary() throws Exception {
        log.trace("update summary");
        Calendar lastUpdate = null;
        try {
            lastUpdate = Utils.lastupdate();
        }
        catch (Exception e) {
            log.error("could not retrieve last update", (Throwable)e);
        }
        RecordIterator records = new RecordIterator();
        long cardinality = 0L;
        while (records.hasNext()) {
            try {
                records.next();
                ++cardinality;
            }
            catch (Exception e) {
                log.error("could not count record", (Throwable)e);
            }
        }
        return new Summary(lastUpdate, cardinality);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (FishFinderPlugin.jdbc == null || FishFinderPlugin.dbLogin == null || FishFinderPlugin.dbPassword == null || FishFinderPlugin.baseUrl == null || FishFinderPlugin.extractAllCsv == null || FishFinderPlugin.reinitialize == null) {
            Utils.getRuntimeResource();
        }
    }
}

