/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.pools;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.operating.MyThreadFactory;
import org.gcube.data.harmonization.occurrence.pools.ExtendedExecutor;

public class MyPooledExecutor
extends ThreadPoolExecutor
implements ExtendedExecutor {
    private static final GCUBELog logger = new GCUBELog(MyPooledExecutor.class);

    private MyPooledExecutor(final String threadLabel, int maxThread) {
        super(maxThread, maxThread, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxThread * 2), new MyThreadFactory(threadLabel), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                try {
                    logger.info((Object)("Request queue for  " + threadLabel + " full, blocking request. Pool stats : " + ((ExtendedExecutor)((Object)e)).getDetails()));
                    e.getQueue().put(r);
                }
                catch (InterruptedException e1) {
                    logger.warn((Object)("Work discarded because thread was interrupted while waiting to schedule: " + r));
                }
            }
        });
    }

    @Override
    public String getDetails() {
        StringBuilder statusBuilder = new StringBuilder();
        statusBuilder.append("Active Count : " + this.getActiveCount() + ";");
        statusBuilder.append("Core Size : " + this.getCorePoolSize() + ";");
        statusBuilder.append("Maximum pool size: " + this.getMaximumPoolSize() + ";");
        statusBuilder.append("Current Queue size: " + this.getQueue().size() + ";");
        statusBuilder.append("Largest pool size : " + this.getLargestPoolSize() + ";");
        statusBuilder.append("Executed Count : " + this.getCompletedTaskCount() + ";");
        return statusBuilder.toString();
    }

    public static ExtendedExecutor getExecutor(String threadLabel, int maxThread) {
        return new MyPooledExecutor(threadLabel, maxThread);
    }
}

