/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.queue;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.MessageProperties;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionReference;
import org.gcube.data.harmonization.occurrence.services.ServiceContext;

public class QueueSender {
    private static GCUBELog logger = new GCUBELog(QueueSender.class);
    private Channel channel;
    private String routingKey;

    public QueueSender(Channel channel, String routingKey) throws IOException {
        this.channel = channel;
        this.routingKey = routingKey;
        this.channel.exchangeDeclare(this.getExchangeName(), "topic");
        this.channel.queueDeclare(this.getExchangeName(), true, false, false, null);
    }

    public String getExchangeName() {
        return ServiceContext.getContext().getName();
    }

    public void sendMessage(ExecutionReference.ExecutionRequest toSendMessage) throws IOException {
        this.channel.basicPublish(this.getExchangeName(), this.routingKey, MessageProperties.PERSISTENT_TEXT_PLAIN, new XStream().toXML((Object)toSendMessage).getBytes());
        logger.info((Object)("Sent Message " + toSendMessage + " to Routing Key :" + this.routingKey));
    }
}

