/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.impl.model.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.impl.model.PagedRequestSettings;
import org.gcube.data.harmonization.occurrence.impl.model.db.Utils;

public class TableConnectionDescriptor {
    private static final GCUBELog logger = new GCUBELog(TableConnectionDescriptor.class);
    private String connectionUrl;
    private long count;
    private Connection conn;
    private List<String> columns = new ArrayList<String>();
    private String tableName;

    public TableConnectionDescriptor(String connectionUrl, String tableName) throws SQLException {
        logger.trace((Object)("Instatiating, connection url : " + connectionUrl + ", tableName : " + tableName));
        this.tableName = tableName;
        this.connectionUrl = connectionUrl;
        this.conn = DriverManager.getConnection(connectionUrl);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            logger.debug((Object)("Acquiring metadata for table " + tableName + "..."));
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " LIMIT 1 OFFSET 0");
            ResultSetMetaData meta = rs.getMetaData();
            int i = 1;
            while (i <= meta.getColumnCount()) {
                this.columns.add(meta.getColumnName(i));
                ++i;
            }
            rs.close();
            logger.debug((Object)("Acquiring total count for table " + tableName));
            rs = stmt.executeQuery("SELECT COUNT (*) FROM " + tableName);
            rs.next();
            this.count = rs.getLong(1);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getJSON(PagedRequestSettings settings) throws SQLException {
        logger.debug((Object)("Getting JSON view " + settings + " on table " + this.tableName));
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM " + this.tableName + " ORDER BY " + settings.getOrderByField() + " " + (Object)((Object)settings.getOrder()) + " LIMIT " + settings.getPageSize() + " OFFSET " + settings.getOffset());
            String string = Utils.toJSon(rs, this.count);
            return string;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    public Connection getConn() {
        return this.conn;
    }
}

