/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.binders;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.encoding.Base64;
import org.gcube.data.oai.tmplugin.Constants;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import uiuc.oai.OAIRecord;

public class OAIDCBinder
implements Serializable {
    private static final long serialVersionUID = -8037198825787888863L;
    private static final Logger log = LoggerFactory.getLogger(OAIDCBinder.class);
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final String oaidc_schema = "http://www.openarchives.org/OAI/2.0/oai_dc/";
    private static final String oaidc_prefix = "oai_dc";

    public Tree bind(OAIRecord record) throws Exception {
        try {
            Tree tree = new Tree(record.getIdentifier());
            Calendar timestamp = Constants.getDate(record.getDatestamp());
            Edge creationTimeEdge = Nodes.e((String)"creationTime", (Object)timestamp);
            Edge lastUpdateTimeEdge = Nodes.e((String)"lastUpdateTime", (Object)timestamp);
            tree.add(new Edge[]{creationTimeEdge, lastUpdateTimeEdge});
            StringWriter writer = new StringWriter();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(record.getMetadata()), new StreamResult(writer));
            String metadata = writer.toString();
            try {
                Edge mEdge = this.createMetadataEdge(metadata, oaidc_prefix, oaidc_schema, tree.id(), creationTimeEdge, lastUpdateTimeEdge);
                tree.add(mEdge);
            }
            catch (Exception te) {
                log.warn("error retrieving the metadata", (Throwable)te);
            }
            Document metadataDocument = factory.newDocumentBuilder().parse(new InputSource(new StringReader(writer.toString())));
            Edge mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"");
            Edge lengthEdge = Nodes.e((String)"length", (Object)0);
            Edge contentEdge = Nodes.e((String)"url", (Object)"");
            Edge nameEdge = Nodes.e((String)"name", (Object)record.getIdentifier());
            tree.add(new Edge[]{mimeTypeEdge, lengthEdge, contentEdge, nameEdge});
            return tree;
        }
        catch (Exception e) {
            log.error("could not convert record:" + record, (Throwable)e);
            throw new Exception("could not convert record", e);
        }
    }

    private Edge createMetadataEdge(String metadata, String prefix, String schema, String identifier, Edge createTimeEdge, Edge lastUpdateTimeEdge) throws Exception {
        return Nodes.e((String)"isDescribedBy", (Node)new InnerNode(identifier + "-" + prefix, new Edge[]{Nodes.e((String)"mimeType", (Object)"text/xml"), Nodes.e((String)"length", (Object)metadata.length()), Nodes.e((String)"language", (Object)"unknown"), Nodes.e((String)"schemaName", (Object)prefix), Nodes.e((String)"schemaURI", (Object)schema), Nodes.e((String)"bytestream", (Object)Base64.encode((byte[])metadata.getBytes("utf-8"))), createTimeEdge, lastUpdateTimeEdge}));
    }
}

