/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.repository.iterators;

import java.net.URI;
import java.util.NoSuchElementException;
import org.gcube.common.OAIException;
import org.gcube.common.OAIRecord;
import org.gcube.common.OAIRecordList;
import org.gcube.data.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecordIterator
implements Stream<OAIRecord> {
    OAIRecordList records = null;
    private static final Logger log = LoggerFactory.getLogger(RecordIterator.class);

    public OAIRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        OAIRecord record = null;
        try {
            do {
                record = this.records.getCurrentItem();
                this.records.moveNext();
            } while (this.notValid(record));
        }
        catch (OAIException e) {
            log.warn("an error occurred trying to retrieve a record (moving to the next element)", (Throwable)e);
        }
        return record;
    }

    private boolean notValid(OAIRecord record) throws OAIException {
        if (record == null || record.deleted() || !record.isRecordValid() || record.getMetadata() == null) {
            log.info("record not valid " + record.getIdentifier());
            return true;
        }
        return false;
    }

    public URI locator() {
        return null;
    }

    public void close() {
    }

    public void remove() {
    }
}

